// Minimized and bundled source code for opatomic client. see https://github.com/opatomic/opac-js for more info
/* BigInteger (http://www-cs-students.stanford.edu/~tjw/jsbn/) LICENSE file: */
/*
Licensing
---------

This software is covered under the following copyright:

 * Copyright (c) 2003-2005  Tom Wu
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * In addition, the following condition applies:
 *
 * All redistributions must retain an intact copy of this copyright notice
 * and disclaimer.

Address all questions regarding this license to:

  Tom Wu
  tjw@cs.Stanford.EDU
*/

(function() {
var BigInteger=function(){function f(a,b,c){null!=a&&("number"==typeof a?this.fromNumber(a,b,c):null==b&&"string"!=typeof a?this.fromString(a,256):this.fromString(a,b))}function l(){return new f(null)}function K(a,b,c,d,e,g){for(;0<=--g;){var h=b*this[a++]+c[d]+e;e=Math.floor(h/67108864);c[d++]=h&67108863}return e}function L(a,b,c,d,e,g){var h=b&32767;for(b>>=15;0<=--g;){var k=this[a]&32767,p=this[a++]>>15,m=b*k+p*h;k=h*k+((m&32767)<<15)+c[d]+(e&1073741823);e=(k>>>30)+(m>>>15)+b*p+(e>>>30);c[d++]=
k&1073741823}return e}function M(a,b,c,d,e,g){var h=b&16383;for(b>>=14;0<=--g;){var k=this[a]&16383,p=this[a++]>>14,m=b*k+p*h;k=h*k+((m&16383)<<14)+c[d]+e;e=(k>>28)+(m>>14)+b*p;c[d++]=k&268435455}return e}function G(a,b){a=B[a.charCodeAt(b)];return null==a?-1:a}function v(a){var b=l();b.fromInt(a);return b}function C(a){var b=1,c;0!=(c=a>>>16)&&(a=c,b+=16);0!=(c=a>>8)&&(a=c,b+=8);0!=(c=a>>4)&&(a=c,b+=4);0!=(c=a>>2)&&(a=c,b+=2);0!=a>>1&&(b+=1);return b}function x(a){this.m=a}function y(a){this.m=a;
this.mp=a.invDigit();this.mpl=this.mp&32767;this.mph=this.mp>>15;this.um=(1<<a.DB-15)-1;this.mt2=2*a.t}function N(a,b){return a&b}function E(a,b){return a|b}function H(a,b){return a^b}function I(a,b){return a&~b}function A(){}function J(a){return a}function z(a){this.r2=l();this.q3=l();f.ONE.dlShiftTo(2*a.t,this.r2);this.mu=this.r2.divide(a);this.m=a}if("Microsoft Internet Explorer"==navigator.appName){f.prototype.am=L;var r=30}else"Netscape"!=navigator.appName?(f.prototype.am=K,r=26):(f.prototype.am=
M,r=28);f.prototype.DB=r;f.prototype.DM=(1<<r)-1;f.prototype.DV=1<<r;f.prototype.FV=Math.pow(2,52);f.prototype.F1=52-r;f.prototype.F2=2*r-52;var B=[],t;r=48;for(t=0;9>=t;++t)B[r++]=t;r=97;for(t=10;36>t;++t)B[r++]=t;r=65;for(t=10;36>t;++t)B[r++]=t;x.prototype.convert=function(a){return 0>a.s||0<=a.compareTo(this.m)?a.mod(this.m):a};x.prototype.revert=function(a){return a};x.prototype.reduce=function(a){a.divRemTo(this.m,null,a)};x.prototype.mulTo=function(a,b,c){a.multiplyTo(b,c);this.reduce(c)};x.prototype.sqrTo=
function(a,b){a.squareTo(b);this.reduce(b)};y.prototype.convert=function(a){var b=l();a.abs().dlShiftTo(this.m.t,b);b.divRemTo(this.m,null,b);0>a.s&&0<b.compareTo(f.ZERO)&&this.m.subTo(b,b);return b};y.prototype.revert=function(a){var b=l();a.copyTo(b);this.reduce(b);return b};y.prototype.reduce=function(a){for(;a.t<=this.mt2;)a[a.t++]=0;for(var b=0;b<this.m.t;++b){var c=a[b]&32767,d=c*this.mpl+((c*this.mph+(a[b]>>15)*this.mpl&this.um)<<15)&a.DM;c=b+this.m.t;for(a[c]+=this.m.am(0,d,a,b,0,this.m.t);a[c]>=
a.DV;)a[c]-=a.DV,a[++c]++}a.clamp();a.drShiftTo(this.m.t,a);0<=a.compareTo(this.m)&&a.subTo(this.m,a)};y.prototype.mulTo=function(a,b,c){a.multiplyTo(b,c);this.reduce(c)};y.prototype.sqrTo=function(a,b){a.squareTo(b);this.reduce(b)};f.prototype.copyTo=function(a){for(var b=this.t-1;0<=b;--b)a[b]=this[b];a.t=this.t;a.s=this.s};f.prototype.fromInt=function(a){this.t=1;this.s=0>a?-1:0;0<a?this[0]=a:-1>a?this[0]=a+this.DV:this.t=0};f.prototype.fromString=function(a,b){if(16==b)b=4;else if(8==b)b=3;else if(256==
b)b=8;else if(2==b)b=1;else if(32==b)b=5;else if(4==b)b=2;else{this.fromRadix(a,b);return}this.s=this.t=0;for(var c=a.length,d=!1,e=0;0<=--c;){var g=8==b?a[c]&255:G(a,c);0>g?"-"==a.charAt(c)&&(d=!0):(d=!1,0==e?this[this.t++]=g:e+b>this.DB?(this[this.t-1]|=(g&(1<<this.DB-e)-1)<<e,this[this.t++]=g>>this.DB-e):this[this.t-1]|=g<<e,e+=b,e>=this.DB&&(e-=this.DB))}8==b&&0!=(a[0]&128)&&(this.s=-1,0<e&&(this[this.t-1]|=(1<<this.DB-e)-1<<e));this.clamp();d&&f.ZERO.subTo(this,this)};f.prototype.clamp=function(){for(var a=
this.s&this.DM;0<this.t&&this[this.t-1]==a;)--this.t};f.prototype.dlShiftTo=function(a,b){var c;for(c=this.t-1;0<=c;--c)b[c+a]=this[c];for(c=a-1;0<=c;--c)b[c]=0;b.t=this.t+a;b.s=this.s};f.prototype.drShiftTo=function(a,b){for(var c=a;c<this.t;++c)b[c-a]=this[c];b.t=Math.max(this.t-a,0);b.s=this.s};f.prototype.lShiftTo=function(a,b){var c=a%this.DB,d=this.DB-c,e=(1<<d)-1;a=Math.floor(a/this.DB);var g=this.s<<c&this.DM,h;for(h=this.t-1;0<=h;--h)b[h+a+1]=this[h]>>d|g,g=(this[h]&e)<<c;for(h=a-1;0<=h;--h)b[h]=
0;b[a]=g;b.t=this.t+a+1;b.s=this.s;b.clamp()};f.prototype.rShiftTo=function(a,b){b.s=this.s;var c=Math.floor(a/this.DB);if(c>=this.t)b.t=0;else{a%=this.DB;var d=this.DB-a,e=(1<<a)-1;b[0]=this[c]>>a;for(var g=c+1;g<this.t;++g)b[g-c-1]|=(this[g]&e)<<d,b[g-c]=this[g]>>a;0<a&&(b[this.t-c-1]|=(this.s&e)<<d);b.t=this.t-c;b.clamp()}};f.prototype.subTo=function(a,b){for(var c=0,d=0,e=Math.min(a.t,this.t);c<e;)d+=this[c]-a[c],b[c++]=d&this.DM,d>>=this.DB;if(a.t<this.t){for(d-=a.s;c<this.t;)d+=this[c],b[c++]=
d&this.DM,d>>=this.DB;d+=this.s}else{for(d+=this.s;c<a.t;)d-=a[c],b[c++]=d&this.DM,d>>=this.DB;d-=a.s}b.s=0>d?-1:0;-1>d?b[c++]=this.DV+d:0<d&&(b[c++]=d);b.t=c;b.clamp()};f.prototype.multiplyTo=function(a,b){var c=this.abs(),d=a.abs(),e=c.t;for(b.t=e+d.t;0<=--e;)b[e]=0;for(e=0;e<d.t;++e)b[e+c.t]=c.am(0,d[e],b,e,0,c.t);b.s=0;b.clamp();this.s!=a.s&&f.ZERO.subTo(b,b)};f.prototype.squareTo=function(a){for(var b=this.abs(),c=a.t=2*b.t;0<=--c;)a[c]=0;for(c=0;c<b.t-1;++c){var d=b.am(c,b[c],a,2*c,0,1);(a[c+
b.t]+=b.am(c+1,2*b[c],a,2*c+1,d,b.t-c-1))>=b.DV&&(a[c+b.t]-=b.DV,a[c+b.t+1]=1)}0<a.t&&(a[a.t-1]+=b.am(c,b[c],a,2*c,0,1));a.s=0;a.clamp()};f.prototype.divRemTo=function(a,b,c){var d=a.abs();if(!(0>=d.t)){var e=this.abs();if(e.t<d.t)null!=b&&b.fromInt(0),null!=c&&this.copyTo(c);else{null==c&&(c=l());var g=l(),h=this.s;a=a.s;var k=this.DB-C(d[d.t-1]);0<k?(d.lShiftTo(k,g),e.lShiftTo(k,c)):(d.copyTo(g),e.copyTo(c));d=g.t;e=g[d-1];if(0!=e){var p=e*(1<<this.F1)+(1<d?g[d-2]>>this.F2:0),m=this.FV/p;p=(1<<
this.F1)/p;var D=1<<this.F2,n=c.t,u=n-d,w=null==b?l():b;g.dlShiftTo(u,w);0<=c.compareTo(w)&&(c[c.t++]=1,c.subTo(w,c));f.ONE.dlShiftTo(d,w);for(w.subTo(g,g);g.t<d;)g[g.t++]=0;for(;0<=--u;){var F=c[--n]==e?this.DM:Math.floor(c[n]*m+(c[n-1]+D)*p);if((c[n]+=g.am(0,F,c,u,0,d))<F)for(g.dlShiftTo(u,w),c.subTo(w,c);c[n]<--F;)c.subTo(w,c)}null!=b&&(c.drShiftTo(d,b),h!=a&&f.ZERO.subTo(b,b));c.t=d;c.clamp();0<k&&c.rShiftTo(k,c);0>h&&f.ZERO.subTo(c,c)}}}};f.prototype.invDigit=function(){if(1>this.t)return 0;
var a=this[0];if(0==(a&1))return 0;var b=a&3;b=b*(2-(a&15)*b)&15;b=b*(2-(a&255)*b)&255;b=b*(2-((a&65535)*b&65535))&65535;b=b*(2-a*b%this.DV)%this.DV;return 0<b?this.DV-b:-b};f.prototype.isEven=function(){return 0==(0<this.t?this[0]&1:this.s)};f.prototype.exp=function(a,b){if(4294967295<a||1>a)return f.ONE;var c=l(),d=l(),e=b.convert(this),g=C(a)-1;for(e.copyTo(c);0<=--g;)if(b.sqrTo(c,d),0<(a&1<<g))b.mulTo(d,e,c);else{var h=c;c=d;d=h}return b.revert(c)};f.prototype.toString=function(a){if(0>this.s)return"-"+
this.negate().toString(a);if(16==a)a=4;else if(8==a)a=3;else if(2==a)a=1;else if(32==a)a=5;else if(4==a)a=2;else return this.toRadix(a);var b=(1<<a)-1,c,d=!1,e="",g=this.t,h=this.DB-g*this.DB%a;if(0<g--)for(h<this.DB&&0<(c=this[g]>>h)&&(d=!0,e="0123456789abcdefghijklmnopqrstuvwxyz".charAt(c));0<=g;)h<a?(c=(this[g]&(1<<h)-1)<<a-h,c|=this[--g]>>(h+=this.DB-a)):(c=this[g]>>(h-=a)&b,0>=h&&(h+=this.DB,--g)),0<c&&(d=!0),d&&(e+="0123456789abcdefghijklmnopqrstuvwxyz".charAt(c));return d?e:"0"};f.prototype.negate=
function(){var a=l();f.ZERO.subTo(this,a);return a};f.prototype.abs=function(){return 0>this.s?this.negate():this};f.prototype.compareTo=function(a){var b=this.s-a.s;if(0!=b)return b;var c=this.t;b=c-a.t;if(0!=b)return 0>this.s?-b:b;for(;0<=--c;)if(0!=(b=this[c]-a[c]))return b;return 0};f.prototype.bitLength=function(){return 0>=this.t?0:this.DB*(this.t-1)+C(this[this.t-1]^this.s&this.DM)};f.prototype.mod=function(a){var b=l();this.abs().divRemTo(a,null,b);0>this.s&&0<b.compareTo(f.ZERO)&&a.subTo(b,
b);return b};f.prototype.modPowInt=function(a,b){b=256>a||b.isEven()?new x(b):new y(b);return this.exp(a,b)};f.ZERO=v(0);f.ONE=v(1);A.prototype.convert=J;A.prototype.revert=J;A.prototype.mulTo=function(a,b,c){a.multiplyTo(b,c)};A.prototype.sqrTo=function(a,b){a.squareTo(b)};z.prototype.convert=function(a){if(0>a.s||a.t>2*this.m.t)return a.mod(this.m);if(0>a.compareTo(this.m))return a;var b=l();a.copyTo(b);this.reduce(b);return b};z.prototype.revert=function(a){return a};z.prototype.reduce=function(a){a.drShiftTo(this.m.t-
1,this.r2);a.t>this.m.t+1&&(a.t=this.m.t+1,a.clamp());this.mu.multiplyUpperTo(this.r2,this.m.t+1,this.q3);for(this.m.multiplyLowerTo(this.q3,this.m.t+1,this.r2);0>a.compareTo(this.r2);)a.dAddOffset(1,this.m.t+1);for(a.subTo(this.r2,a);0<=a.compareTo(this.m);)a.subTo(this.m,a)};z.prototype.mulTo=function(a,b,c){a.multiplyTo(b,c);this.reduce(c)};z.prototype.sqrTo=function(a,b){a.squareTo(b);this.reduce(b)};var q=[2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,
113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,907,
911,919,929,937,941,947,953,967,971,977,983,991,997],O=67108864/q[q.length-1];f.prototype.chunkSize=function(a){return Math.floor(Math.LN2*this.DB/Math.log(a))};f.prototype.toRadix=function(a){null==a&&(a=10);if(0==this.signum()||2>a||36<a)return"0";var b=this.chunkSize(a);b=Math.pow(a,b);var c=v(b),d=l(),e=l(),g="";for(this.divRemTo(c,d,e);0<d.signum();)g=(b+e.intValue()).toString(a).substr(1)+g,d.divRemTo(c,d,e);return e.intValue().toString(a)+g};f.prototype.fromRadix=function(a,b){this.fromInt(0);
null==b&&(b=10);for(var c=this.chunkSize(b),d=Math.pow(b,c),e=!1,g=0,h=0,k=0;k<a.length;++k){var p=G(a,k);0>p?"-"==a.charAt(k)&&0==this.signum()&&(e=!0):(h=b*h+p,++g>=c&&(this.dMultiply(d),this.dAddOffset(h,0),h=g=0))}0<g&&(this.dMultiply(Math.pow(b,g)),this.dAddOffset(h,0));e&&f.ZERO.subTo(this,this)};f.prototype.fromNumber=function(a,b,c){if("number"==typeof b)if(2>a)this.fromInt(1);else for(this.fromNumber(a,c),this.testBit(a-1)||this.bitwiseTo(f.ONE.shiftLeft(a-1),E,this),this.isEven()&&this.dAddOffset(1,
0);!this.isProbablePrime(b);)this.dAddOffset(2,0),this.bitLength()>a&&this.subTo(f.ONE.shiftLeft(a-1),this);else{c=[];var d=a&7;c.length=(a>>3)+1;b.nextBytes(c);c[0]=0<d?c[0]&(1<<d)-1:0;this.fromString(c,256)}};f.prototype.bitwiseTo=function(a,b,c){var d,e=Math.min(a.t,this.t);for(d=0;d<e;++d)c[d]=b(this[d],a[d]);if(a.t<this.t){var g=a.s&this.DM;for(d=e;d<this.t;++d)c[d]=b(this[d],g);c.t=this.t}else{g=this.s&this.DM;for(d=e;d<a.t;++d)c[d]=b(g,a[d]);c.t=a.t}c.s=b(this.s,a.s);c.clamp()};f.prototype.changeBit=
function(a,b){a=f.ONE.shiftLeft(a);this.bitwiseTo(a,b,a);return a};f.prototype.addTo=function(a,b){for(var c=0,d=0,e=Math.min(a.t,this.t);c<e;)d+=this[c]+a[c],b[c++]=d&this.DM,d>>=this.DB;if(a.t<this.t){for(d+=a.s;c<this.t;)d+=this[c],b[c++]=d&this.DM,d>>=this.DB;d+=this.s}else{for(d+=this.s;c<a.t;)d+=a[c],b[c++]=d&this.DM,d>>=this.DB;d+=a.s}b.s=0>d?-1:0;0<d?b[c++]=d:-1>d&&(b[c++]=this.DV+d);b.t=c;b.clamp()};f.prototype.dMultiply=function(a){this[this.t]=this.am(0,a-1,this,0,0,this.t);++this.t;this.clamp()};
f.prototype.dAddOffset=function(a,b){if(0!=a){for(;this.t<=b;)this[this.t++]=0;for(this[b]+=a;this[b]>=this.DV;)this[b]-=this.DV,++b>=this.t&&(this[this.t++]=0),++this[b]}};f.prototype.multiplyLowerTo=function(a,b,c){var d=Math.min(this.t+a.t,b);c.s=0;for(c.t=d;0<d;)c[--d]=0;var e;for(e=c.t-this.t;d<e;++d)c[d+this.t]=this.am(0,a[d],c,d,0,this.t);for(e=Math.min(a.t,b);d<e;++d)this.am(0,a[d],c,d,0,b-d);c.clamp()};f.prototype.multiplyUpperTo=function(a,b,c){--b;var d=c.t=this.t+a.t-b;for(c.s=0;0<=--d;)c[d]=
0;for(d=Math.max(b-this.t,0);d<a.t;++d)c[this.t+d-b]=this.am(b-d,a[d],c,0,0,this.t+d-b);c.clamp();c.drShiftTo(1,c)};f.prototype.modInt=function(a){if(0>=a)return 0;var b=this.DV%a,c=0>this.s?a-1:0;if(0<this.t)if(0==b)c=this[0]%a;else for(var d=this.t-1;0<=d;--d)c=(b*c+this[d])%a;return c};f.prototype.millerRabin=function(a){var b=this.subtract(f.ONE),c=b.getLowestSetBit();if(0>=c)return!1;var d=b.shiftRight(c);a=a+1>>1;a>q.length&&(a=q.length);for(var e=l(),g=0;g<a;++g){e.fromInt(q[Math.floor(Math.random()*
q.length)]);var h=e.modPow(d,this);if(0!=h.compareTo(f.ONE)&&0!=h.compareTo(b)){for(var k=1;k++<c&&0!=h.compareTo(b);)if(h=h.modPowInt(2,this),0==h.compareTo(f.ONE))return!1;if(0!=h.compareTo(b))return!1}}return!0};f.prototype.clone=function(){var a=l();this.copyTo(a);return a};f.prototype.intValue=function(){if(0>this.s){if(1==this.t)return this[0]-this.DV;if(0==this.t)return-1}else{if(1==this.t)return this[0];if(0==this.t)return 0}return(this[1]&(1<<32-this.DB)-1)<<this.DB|this[0]};f.prototype.byteValue=
function(){return 0==this.t?this.s:this[0]<<24>>24};f.prototype.shortValue=function(){return 0==this.t?this.s:this[0]<<16>>16};f.prototype.signum=function(){return 0>this.s?-1:0>=this.t||1==this.t&&0>=this[0]?0:1};f.prototype.toByteArray=function(){var a=this.t,b=[];b[0]=this.s;var c=this.DB-a*this.DB%8,d,e=0;if(0<a--)for(c<this.DB&&(d=this[a]>>c)!=(this.s&this.DM)>>c&&(b[e++]=d|this.s<<this.DB-c);0<=a;)if(8>c?(d=(this[a]&(1<<c)-1)<<8-c,d|=this[--a]>>(c+=this.DB-8)):(d=this[a]>>(c-=8)&255,0>=c&&(c+=
this.DB,--a)),0!=(d&128)&&(d|=-256),0==e&&(this.s&128)!=(d&128)&&++e,0<e||d!=this.s)b[e++]=d;return b};f.prototype.equals=function(a){return 0==this.compareTo(a)};f.prototype.min=function(a){return 0>this.compareTo(a)?this:a};f.prototype.max=function(a){return 0<this.compareTo(a)?this:a};f.prototype.and=function(a){var b=l();this.bitwiseTo(a,N,b);return b};f.prototype.or=function(a){var b=l();this.bitwiseTo(a,E,b);return b};f.prototype.xor=function(a){var b=l();this.bitwiseTo(a,H,b);return b};f.prototype.andNot=
function(a){var b=l();this.bitwiseTo(a,I,b);return b};f.prototype.not=function(){for(var a=l(),b=0;b<this.t;++b)a[b]=this.DM&~this[b];a.t=this.t;a.s=~this.s;return a};f.prototype.shiftLeft=function(a){var b=l();0>a?this.rShiftTo(-a,b):this.lShiftTo(a,b);return b};f.prototype.shiftRight=function(a){var b=l();0>a?this.lShiftTo(-a,b):this.rShiftTo(a,b);return b};f.prototype.getLowestSetBit=function(){for(var a=0;a<this.t;++a)if(0!=this[a]){var b=a*this.DB;a=this[a];if(0==a)a=-1;else{var c=0;0==(a&65535)&&
(a>>=16,c+=16);0==(a&255)&&(a>>=8,c+=8);0==(a&15)&&(a>>=4,c+=4);0==(a&3)&&(a>>=2,c+=2);0==(a&1)&&++c;a=c}return b+a}return 0>this.s?this.t*this.DB:-1};f.prototype.bitCount=function(){for(var a=0,b=this.s&this.DM,c=0;c<this.t;++c){for(var d=this[c]^b,e=0;0!=d;)d&=d-1,++e;a+=e}return a};f.prototype.testBit=function(a){var b=Math.floor(a/this.DB);return b>=this.t?0!=this.s:0!=(this[b]&1<<a%this.DB)};f.prototype.setBit=function(a){return this.changeBit(a,E)};f.prototype.clearBit=function(a){return this.changeBit(a,
I)};f.prototype.flipBit=function(a){return this.changeBit(a,H)};f.prototype.add=function(a){var b=l();this.addTo(a,b);return b};f.prototype.subtract=function(a){var b=l();this.subTo(a,b);return b};f.prototype.multiply=function(a){var b=l();this.multiplyTo(a,b);return b};f.prototype.divide=function(a){var b=l();this.divRemTo(a,b,null);return b};f.prototype.remainder=function(a){var b=l();this.divRemTo(a,null,b);return b};f.prototype.divideAndRemainder=function(a){var b=l(),c=l();this.divRemTo(a,b,
c);return[b,c]};f.prototype.modPow=function(a,b){var c=a.bitLength(),d=v(1);if(0>=c)return d;var e=18>c?1:48>c?3:144>c?4:768>c?5:6;b=8>c?new x(b):b.isEven()?new z(b):new y(b);var g=[],h=3,k=e-1,p=(1<<e)-1;g[1]=b.convert(this);if(1<e)for(c=l(),b.sqrTo(g[1],c);h<=p;)g[h]=l(),b.mulTo(c,g[h-2],g[h]),h+=2;var m=a.t-1,D=!0,n=l();for(c=C(a[m])-1;0<=m;){if(c>=k)var u=a[m]>>c-k&p;else u=(a[m]&(1<<c+1)-1)<<k-c,0<m&&(u|=a[m-1]>>this.DB+c-k);for(h=e;0==(u&1);)u>>=1,--h;0>(c-=h)&&(c+=this.DB,--m);if(D)g[u].copyTo(d),
D=!1;else{for(;1<h;)b.sqrTo(d,n),b.sqrTo(n,d),h-=2;0<h?b.sqrTo(d,n):(h=d,d=n,n=h);b.mulTo(n,g[u],d)}for(;0<=m&&0==(a[m]&1<<c);)b.sqrTo(d,n),h=d,d=n,n=h,0>--c&&(c=this.DB-1,--m)}return b.revert(d)};f.prototype.modInverse=function(a){var b=a.isEven();if(this.isEven()&&b||0==a.signum())return f.ZERO;for(var c=a.clone(),d=this.clone(),e=v(1),g=v(0),h=v(0),k=v(1);0!=c.signum();){for(;c.isEven();)c.rShiftTo(1,c),b?(e.isEven()&&g.isEven()||(e.addTo(this,e),g.subTo(a,g)),e.rShiftTo(1,e)):g.isEven()||g.subTo(a,
g),g.rShiftTo(1,g);for(;d.isEven();)d.rShiftTo(1,d),b?(h.isEven()&&k.isEven()||(h.addTo(this,h),k.subTo(a,k)),h.rShiftTo(1,h)):k.isEven()||k.subTo(a,k),k.rShiftTo(1,k);0<=c.compareTo(d)?(c.subTo(d,c),b&&e.subTo(h,e),g.subTo(k,g)):(d.subTo(c,d),b&&h.subTo(e,h),k.subTo(g,k))}if(0!=d.compareTo(f.ONE))return f.ZERO;if(0<=k.compareTo(a))return k.subtract(a);if(0>k.signum())k.addTo(a,k);else return k;return 0>k.signum()?k.add(a):k};f.prototype.pow=function(a){return this.exp(a,new A)};f.prototype.gcd=function(a){var b=
0>this.s?this.negate():this.clone();a=0>a.s?a.negate():a.clone();if(0>b.compareTo(a)){var c=b;b=a;a=c}c=b.getLowestSetBit();var d=a.getLowestSetBit();if(0>d)return b;c<d&&(d=c);0<d&&(b.rShiftTo(d,b),a.rShiftTo(d,a));for(;0<b.signum();)0<(c=b.getLowestSetBit())&&b.rShiftTo(c,b),0<(c=a.getLowestSetBit())&&a.rShiftTo(c,a),0<=b.compareTo(a)?(b.subTo(a,b),b.rShiftTo(1,b)):(a.subTo(b,a),a.rShiftTo(1,a));0<d&&a.lShiftTo(d,a);return a};f.prototype.isProbablePrime=function(a){var b,c=this.abs();if(1==c.t&&
c[0]<=q[q.length-1]){for(b=0;b<q.length;++b)if(c[0]==q[b])return!0;return!1}if(c.isEven())return!1;for(b=1;b<q.length;){for(var d=q[b],e=b+1;e<q.length&&d<O;)d*=q[e++];for(d=c.modInt(d);b<e;)if(0==d%q[b++])return!1}return c.millerRabin(a)};f.prototype.square=function(){var a=l();this.squareTo(a);return a};return f}();
var ca=new TextEncoder("utf-8"),da=new TextDecoder("utf-8");var k=Number.isInteger||function(c){return"number"===typeof c&&isFinite(c)&&Math.floor(c)===c},x=Number.isSafeInteger||function(c){return k(c)&&-9007199254740991<=c&&9007199254740991>=c};function D(){}D.UNDEFINED=85;D.NULL=78;D.FALSE=70;D.TRUE=84;D.ZERO=79;D.NEGINF=80;D.POSINF=81;D.EMPTYBIN=65;D.EMPTYSTR=82;D.EMPTYARRAY=77;D.SORTMAX=90;D.POSVARINT=68;D.NEGVARINT=69;D.POSPOSVARDEC=71;D.POSNEGVARDEC=72;D.NEGPOSVARDEC=73;D.NEGNEGVARDEC=74;D.POSBIGINT=75;D.NEGBIGINT=76;D.POSPOSBIGDEC=86;
D.POSNEGBIGDEC=87;D.NEGPOSBIGDEC=88;D.NEGNEGBIGDEC=89;D.BINLPVI=66;D.STRLPVI=83;D.ARRAYSTART=91;D.ARRAYEND=93;D.SORTMAX_OBJ=new function(){this.toString=function(){return"SORTMAX"}};D.ERR_CLOSED=-1;function H(c,d){BigInteger.ZERO.subTo(c,d);return d}function I(c){if(0>c)return c=I(0-c),H(c,c);if(0==c)return BigInteger.ZERO.clone();if(!x(c))throw Error("arg is not safe integer");var d=new BigInteger(null);d.s=0;d.t=1;d[0]=c&d.DM;c=Math.floor(c/d.DV);for(var f=1;0<c;++f)d[f]=c&d.DM,++d.t,c=Math.floor(c/d.DV);return d}
function J(c,d,f,n){f=new BigInteger(null);f.t=0;for(var q=f.s=0;0<=--n;){var e=d[n]&255;0==q?f[f.t++]=e:q+8>f.DB?(f[f.t-1]|=(e&(1<<f.DB-q)-1)<<q,f[f.t++]=e>>f.DB-q):f[f.t-1]|=e<<q;q+=8;q>=f.DB&&(q-=f.DB)}f.clamp();return c?H(f,f):f};function K(c,d){c=Array(c);c.next=null;c.head=0;c.used=0;d&&(d.next=c);return c}function M(){this.totlen=0;this.tail=this.head=K(this.newChunkSize,null)}M.prototype.push=function(c){var d=this.tail;d.used+1>=d.length&&(this.tail=d=K(this.newChunkSize,d));d[d.head+d.used&d.length-1]=c;d.used++;return++this.totlen};M.prototype.shift=function(){var c=this.head;if(0!=c.used){var d=c.head,f=c[d];c[d]=void 0;c.used--;0==c.used&&c.next?this.head=c.next:c.head=d+1&c.length-1;this.totlen--;return f}};
M.prototype.size=function(){return this.totlen};M.prototype.newChunkSize=64;var N={UP:0,DOWN:1,CEILING:2,FLOOR:3,HALF_UP:4,HALF_DOWN:5,HALF_EVEN:6,UNNECESSARY:7};
function P(c,d){function f(q,e){var r=e.indexOf(".");0<=r&&(e=e.replace(".",""));var v=e.indexOf("e");0>v&&(v=e.indexOf("E"));if(0>v)q.m=new BigInteger(e),q.s=0;else{var w=43==e.charCodeAt(v+1)?2:1;q.m=new BigInteger(e.substring(0,v));q.s=0-parseInt(e.substring(v+w),10)}0<=r&&(q.s+=0>v?e.length-r:v-r)}var n=typeof c;if("string"==n)43===c.charCodeAt(0)&&(c=c.substring(1)),f(this,c);else if("number"==n){if(!isFinite(c))throw Error("BigDec does not support Inf/-Inf/NaN");f(this,c.toString())}else this.m=
c?c:new BigInteger("0"),this.s=d?d:0;if(!x(this.s)||-2147483648>this.s||2147483647<this.s)throw Error("scale is out of range");}
(function(){function c(b){return 0==b.signum()}function d(b){if(16>b){var h=V[b];h||(h=y.pow(b),V[b]=h);return h}return y.pow(b)}function f(b,h){return 0==h?b:b.multiply(d(h))}function n(b,h,t){b=b.toBigIntegerExact();if(0>b.compareTo(h)||0<b.compareTo(t))throw Error("Out of range");return b.intValue()}function q(b,h,t,m){var A=b.divideAndRemainder(h),C=A[0];if(!c(A[1])){var E=0;b=b.signum()*h.signum();switch(m){case N.FLOOR:E=0>b?-1:0;break;case N.CEILING:E=0<b?1:0;break;case N.UP:E=b;break;case N.HALF_DOWN:case N.HALF_EVEN:case N.HALF_UP:h=
A[1].abs().shiftLeft(1).compareTo(h.abs());0<h?E=b:0==h&&(m==N.HALF_UP?E=b:m==N.HALF_EVEN&&(E=C.testBit(0)?b:0));break;case N.UNNECESSARY:throw Error("Rounding mode is UNNECESSARY but rounding is needed");}E&&(C=C.add(0<E?l:a))}return new P(C,t)}function e(b,h){b=b.m;return 0<=h?new P(b,h):new P(f(b,0-h),0)}function r(b,h){var t=b.s;b=b.m;if(0==t)return b;if(0>t)return f(b,0-t);if(!h)return b.divide(d(t));h=b.divideAndRemainder(d(t));if(!c(h[1]))throw Error("rounding required");return h[0]}function v(b,
h){if(String.prototype.repeat)return b.repeat(h);for(var t="";0<h;--h)t+=b;return t}function w(b,h){return b.substring(0,h)+"."+b.substring(h)}function B(b,h){var t=b.m;b=0-b.s;var m=t.toString();if(0!=b){var A="-"==m.charAt(0);m=A?m.substring(1):m;var C=b+m.length-1;if(0>b&&-6<=C)m=0<=C?w(m,m.length+b):"0."+v("0",0-C-1)+m,b=0;else if(h){b=C;h=1;if(c(t))for(;0!=b%3;)m+="0",++b;else for(;0!=b%3;)h>=m.length&&(m+="0"),++h,--b;h<m.length&&(m=w(m,h))}else b=C,1<m.length&&(m=w(m,1));m=A?"-"+m:m;0!=b&&
(m+=(0<b?"E+":"E")+b.toString())}return m}var a=new BigInteger("-1"),g=new BigInteger("0"),l=new BigInteger("1"),p=new BigInteger("5"),y=new BigInteger("10"),u=new BigInteger("-128"),z=new BigInteger("127"),L=new BigInteger("-32768"),fa=new BigInteger("32767"),ha=new BigInteger("-2147483648"),ia=new BigInteger("2147483647"),aa=new P(g),ba=new P(l),V=Array(16);V[0]=l;P.ROUND_CEILING=N.CEILING;P.ROUND_DOWN=N.DOWN;P.ROUND_FLOOR=N.FLOOR;P.ROUND_HALF_DOWN=N.HALF_DOWN;P.ROUND_HALF_EVEN=N.HALF_EVEN;P.ROUND_HALF_UP=
N.HALF_UP;P.ROUND_UNNECESSARY=N.UNNECESSARY;P.ROUND_UP=N.UP;P.ONE=ba;P.TEN=new P(y);P.ZERO=aa;P.prototype.abs=function(){var b=this.m;return 0>b.signum()?new P(b.negate(),this.s):this};P.prototype.add=function(b){var h=this.m,t=b.m,m=this.s;b=b.s;b>m?h=f(h,b-m):m>b&&(t=f(t,m-b));return new P(h.add(t),Math.max(m,b))};P.prototype.byteValue=function(){return this.toBigInteger().byteValue()};P.prototype.byteValueExact=function(){return n(this,u,z)};P.prototype.clone=function(){return new P(this.m.clone(),
this.s)};P.prototype.compareTo=function(b){var h=this.m,t=b.m,m=h.signum(),A=t.signum();if(m!=A)return m<A?-1:1;if(0==m)return 0;b=b.s-this.s;if(0!=b){A=h.bitLength();var C=t.bitLength();if(0<b){if(A>C)return m;h=f(h,b)}else{if(A<C)return 0-m;t=f(t,0-b)}}h=h.compareTo(t);return 0<h?1:0>h?-1:0};P.prototype.divide=function(b,h,t){if(1>=arguments.length){var m=this.m;var A=b.m;if(c(A))throw Error("cannot divide by 0");var C=this.s-b.s;if(c(m))A=new P(g,C);else{var E=m.gcd(A),G=A.divide(E).abs(),F=G.getLowestSetBit();
G=0==F?G:G.shiftRight(F);for(var O=0;0!=G.compareTo(l);++O){G=G.divideAndRemainder(p);if(!c(G[1]))throw Error("quotient is non-terminating");G=G[0]}m=m.divide(E);F>O?m=m.multiply(p.pow(F-O)):(E=F-O,m=0==E?m:m.shiftRight(E));A=new P(0>A.signum()?m.negate():m,C+Math.max(F,O))}return A}if(2==arguments.length)return this.divide(b,this.s,h);A=this.m;C=b.m;if(c(C))throw Error("cannot divide by 0");F=this.s-b.s-h;0>F?A=f(A,0-F):0<F&&(C=f(C,F));return q(A,C,h,t)};P.prototype.divideAndRemainder=function(b){var h=
this.divideToIntegralValue(b);return[h,this.subtract(h.multiply(b))]};P.prototype.divideToIntegralValue=function(b){var h=this.m,t=b.m;if(c(t))throw Error("cannot divide by 0");b=this.s-b.s;if(0==b)h=h.divide(t);else if(0<b){var m=d(b);h=h.divide(t.multiply(m)).multiply(m)}else{h=f(h,0-b).divide(t);for(t=0;t>b;){m=h.divideAndRemainder(y);if(!c(m[1]))break;h=m[0];--t}b=t}return new P(h,b)};P.prototype.equals=function(b){return b instanceof P?this.s==b.s&&0==this.m.compareTo(b.m):!1};P.prototype.intValue=
function(){return this.toBigInteger().intValue()};P.prototype.intValueExact=function(){return n(this,ha,ia)};P.prototype.max=function(b){return 0<=this.compareTo(b)?this:b};P.prototype.min=function(b){return 0>=this.compareTo(b)?this:b};P.prototype.movePointLeft=function(b){return e(this,this.s+b)};P.prototype.movePointRight=function(b){return e(this,this.s-b)};P.prototype.multiply=function(b){return new P(this.m.multiply(b.m),this.s+b.s)};P.prototype.negate=function(){return new P(this.m.negate(),
this.s)};P.prototype.pow=function(b){if(0===b)return ba;if(0>b)throw Error("Invalid power");return new P(this.m.pow(b),this.s*b)};P.prototype.precision=function(){var b=this.m.toString();return b.length-(45==b.charCodeAt(0)?1:0)};P.prototype.remainder=function(b){return this.divideAndRemainder(b)[1]};P.prototype.scale=function(){return this.s};P.prototype.scaleByPowerOfTen=function(b){return 0==b?this:new P(this.m,this.s-b)};P.prototype.setScale=function(b,h){var t=this.m,m=this.s;if(b==m)return this;
if(b>m)return new P(f(t,b-m),b);h=2<=arguments.length?h:N.UNNECESSARY;return q(t,d(m-b),b,h)};P.prototype.shortValue=function(){return this.toBigInteger().shortValue()};P.prototype.shortValueExact=function(){return n(this,L,fa)};P.prototype.signum=function(){return this.m.signum()};P.prototype.stripTrailingZeros=function(){var b=this.m;if(c(b))return aa;for(var h=this.s;;){var t=b.divideAndRemainder(y);if(!c(t[1]))break;--h;b=t[0]}return h==this.s?this:new P(b,h)};P.prototype.subtract=function(b){var h=
this.m,t=b.m,m=this.s;b=b.s;b>m?h=f(h,b-m):m>b&&(t=f(t,m-b));return new P(h.subtract(t),Math.max(m,b))};P.prototype.toBigInteger=function(){return r(this,!1)};P.prototype.toBigIntegerExact=function(){return r(this,!0)};P.prototype.toEngineeringString=function(){return B(this,!0)};P.prototype.toPlainString=function(){var b=this.m,h=0-this.s;if(c(b))return 0>h?"0."+v("0",0-h):"0";b=b.toString();if(0<=h)b+=v("0",h);else{var t=45==b.charCodeAt(0);t&&(b=b.substring(1));t=t?"-":"";h=b.length+h;b=0>=h?t+
"0."+v("0",0-h)+b:t+w(b,h)}return b};P.prototype.toString=function(){return B(this,!1)};P.prototype.ulp=function(){return new P(l,this.s)};P.prototype.unscaledValue=function(){return this.m}})();function Q(){}
(function(){function c(a,g){a.mState=13;throw Error(g);}function d(a,g){null==a.mCurrCont&&c(a,"no array container");a.mCurrCont.push(g)}function f(a,g){d(a,g);4096<a.mBytes.length&&(a.mBytes=B);a.mState=1}function n(a,g,l){a.mState=2;a.mNextState=l;a.mObjType=g;a.mVarintVal1=0;a.mVarintVal2=0;a.mVarintLen=0}function q(a,g){if(g)return 0-q(a,!1);if(5>a.mVarintLen)return a.mVarintVal1;g=4294967296*a.mVarintVal2+a.mVarintVal1;(!x(g)||2147483647<g)&&c(a,"varint out of range");return g}function e(a,g,
l){for(var p=3;0<=p;--p)g[l+p]=a&255,a>>>=8}function r(a,g){if(5>a.mVarintLen)return g?0==a.mVarintVal1?-0:0-a.mVarintVal1:a.mVarintVal1;var l=4294967296*a.mVarintVal2+a.mVarintVal1;if(x(l))return g?0-l:l;e(a.mVarintVal2,w,0);e(a.mVarintVal1,w,4);return J(g,w,0,8)}function v(a,g){var l=g.data,p=g.idx,y=g.idx+g.len;a:for(;;)switch(a.mState){case 1:if(p>=y)return g.idx=p,g.len=0,null;switch(l[p++]){case 85:d(a,void 0);continue;case 78:d(a,null);continue;case 70:d(a,!1);continue;case 84:d(a,!0);continue;
case 79:d(a,0);continue;case 80:d(a,-Infinity);continue;case 81:d(a,Infinity);continue;case 65:d(a,new Uint8Array(0));continue;case 82:d(a,"");continue;case 77:d(a,[]);continue;case 90:d(a,D.SORTMAX_OBJ);continue;case 69:n(a,69,3);continue;case 68:n(a,68,3);continue;case 76:var u=a;n(u,76,9);u.mNextState2=6;continue;case 75:u=a;n(u,75,9);u.mNextState2=6;continue;case 71:n(a,71,4);continue;case 72:n(a,72,4);continue;case 73:n(a,73,4);continue;case 74:n(a,74,4);continue;case 86:n(a,86,7);continue;case 87:n(a,
87,7);continue;case 88:n(a,88,7);continue;case 89:n(a,89,7);continue;case 66:u=a;n(u,66,9);u.mNextState2=11;continue;case 83:u=a;n(u,83,9);u.mNextState2=12;continue;case 91:null!=a.mCurrCont&&a.mContainers.push(a.mCurrCont);a.mCurrCont=[];continue;case 93:null==a.mCurrCont&&c(a,"array end token when not in array");if(0==a.mContainers.length)return l=a.mCurrCont,a.mCurrCont=null,g.idx=p,g.len=y-p,l;u=a.mContainers.pop();u.push(a.mCurrCont);a.mCurrCont=u;continue;default:c(a,"unknown char")}case 2:for(;;){if(p>=
y)return g.idx=p,g.len=0,null;u=l[p++];var z=a,L=u;4>z.mVarintLen?z.mVarintVal1|=(L&127)<<7*z.mVarintLen:4==z.mVarintLen?(z.mVarintVal1+=268435456*(L&15),z.mVarintVal2=(L&112)>>4):9>z.mVarintLen?z.mVarintVal2|=(L&127)<<3+7*(z.mVarintLen-5):c(z,"varint too big");z.mVarintLen++;if(0==(u&128)){a.mState=a.mNextState;continue a}}case 3:d(a,r(a,69==a.mObjType));a.mState=1;continue;case 9:a.mBytesLen=q(a,!1),a.mBytes.length<a.mBytesLen&&(a.mBytes=new Uint8Array(a.mBytesLen)),a.mBytesIdx=0,a.mState=10;case 10:u=
Math.min(y-p,a.mBytesLen-a.mBytesIdx);a.mBytes.set(l.subarray(p,p+u),a.mBytesIdx);a.mBytesIdx+=u;p+=u;if(a.mBytesIdx<a.mBytesLen)return g.idx=p,g.len=0,null;a.mState=a.mNextState2;continue;case 6:f(a,J(76==a.mObjType,a.mBytes,0,a.mBytesLen));continue;case 4:a.mDecExp=q(a,73==a.mObjType||74==a.mObjType);n(a,a.mObjType,5);continue;case 5:u=r(a,72==a.mObjType||74==a.mObjType);u="number"==typeof u?I(u):u;d(a,new P(u,0-a.mDecExp));a.mState=1;continue;case 7:a.mDecExp=q(a,88==a.mObjType||89==a.mObjType);
u=a;n(u,a.mObjType,9);u.mNextState2=8;continue;case 8:u=J(87==a.mObjType||89==a.mObjType,a.mBytes,0,a.mBytesLen);f(a,new P(u,0-a.mDecExp));continue;case 11:d(a,a.mBytes.subarray(0,a.mBytesLen));a.mBytes=B;a.mState=1;continue;case 12:f(a,da.decode(a.mBytes.subarray(0,a.mBytesLen)));continue;default:c(a,"unknown state")}}var w=new Uint8Array(8),B=new Uint8Array(0);Q=function(){this.mContainers=[];this.mCurrCont=null;this.mState=1;this.mBytesLen=this.mBytesIdx=this.mObjType=this.mDecExp=this.mVarintLen=
this.mVarintVal2=this.mVarintVal1=this.mNextState2=this.mNextState=0;this.mBytes=B};Q.prototype.parseNext=function(a){return v(this,a)}})();Q.Buff=function(){this.data=null;this.len=this.idx=0};function R(){}
(function(){function c(a){0<a.i&&(a.c=a.o.write(a.i==a.b.length?a.b:a.b.subarray(0,a.i)),a.i=0);return a.c}function d(a,g,l){a.i+10>a.b.length&&c(a);for(0!=g&&(a.b[a.i++]=g);2147483647<l;)a.b[a.i++]=128|l%128,l=Math.floor(l/128);for(;127<l;)a.b[a.i++]=128|l&255,l>>>=7;a.b[a.i++]=l}function f(a,g,l){if(0>l.signum())f(a,g,H(l,B));else{var p=l.bitLength();p=(p>>3)+(0==(p&7)?0:1);l=l.toByteArray();if(l.length!=p&&l.length!=p+1)throw Error("BigInteger.toByteArray() returned unexpected value");d(a,g,p);
for(g=l.length-p;g<l.length;++g)a.write1(l[g])}}function n(a,g,l){if(0>l.signum())n(a,g,H(l,B));else{a.i+10>a.b.length&&c(a);0!=g&&(a.b[a.i++]=g);if(0<l.compareTo(w))for(l!=B&&(l.copyTo(B),l=B);0<l.compareTo(w);)a.b[a.i++]=128|l.byteValue()&127,l.rShiftTo(7,l);for(g=l.intValue();127<g;)a.b[a.i++]=128|g&255,g>>>=7;a.b[a.i++]=g}}function q(a,g){var l=g.signum();0==l?a.write1(79):0<l?0>=g.compareTo(r)?n(a,68,g):f(a,75,g):0<=g.compareTo(v)?n(a,69,g):f(a,76,g)}function e(a,g){var l=0-g.scale(),p=g.unscaledValue();
if(0==l)q(a,p);else{var y=0>l;l=y?0-l:l;0<g.signum()?0>=p.compareTo(r)?(d(a,y?73:71,l),n(a,0,p)):(d(a,y?88:86,l),f(a,0,p)):0<=p.compareTo(v)?(d(a,y?74:72,l),n(a,0,p)):(d(a,y?89:87,l),f(a,0,p))}}R=function(a,g){if(g&&10>=g)throw Error("buffer len is too small");this.o=a;this.b=new Uint8Array(g?g:4096);this.i=0;this.c=!0};var r=new BigInteger("9223372036854775807"),v=r.negate(),w=new BigInteger("7FFFFFFF",16),B=new BigInteger(null);R.prototype.write1=function(a){this.i>=this.b.length&&c(this);this.b[this.i++]=
a};R.prototype.write=function(a){if(a.length>this.b.length-this.i&&(c(this),a.length>=this.b.length)){this.c=this.o.write(a);return}this.b.set(a,this.i);this.i+=a.length};R.prototype.flush=function(){c(this);"function"===typeof this.o.flush&&this.o.flush()};R.prototype.writeNumber=function(a){if(x(a))0<a?d(this,68,a):0==a&&Infinity==1/a?this.write1(79):d(this,69,0-a);else if(-Infinity===a)this.write1(80);else if(Infinity===a)this.write1(81);else{if("number"!=typeof a)throw Error("not a number");if(isNaN(a))throw Error("number is NaN; cannot be serialized");
e(this,new P(a.toString()))}};R.prototype.writeString=function(a){if(0==a.length)this.write1(82);else if(1024>a.length){for(var g=a.length,l=0+g,p=0;p<l;++p){var y=a.charCodeAt(p);if(!(128>y))if(2048>y)++g;else{if(!(55296>y||57343<y)&&56320>y&&p<l-1&&(y=a.charCodeAt(p+1),56320<=y&&57343>=y)){g+=2;++p;continue}g+=2}}d(this,83,g);l=a.length;g=this.i;p=this.b;for(y=0;y<l;++y){g+4>p.length&&(this.i=g,c(this),g=this.i,p=this.b);var u=a.charCodeAt(y);if(128>u)p[g++]=u;else if(2048>u)p[g++]=192|u>>6,p[g++]=
128|u&63;else if(55296>u||57343<u)p[g++]=224|u>>12,p[g++]=128|u>>6&63,p[g++]=128|u&63;else{if(56320>u&&y<l-1){var z=a.charCodeAt(y+1);if(56320<=z&&57343>=z){z=(u<<10)+z+-56613888;++y;p[g++]=240|z>>18;p[g++]=128|z>>12&63;p[g++]=128|z>>6&63;p[g++]=128|z&63;continue}}p[g++]=239;p[g++]=191;p[g++]=189}}this.i=g}else a=ca.encode(a),d(this,83,a.length),this.write(a)};R.prototype.writeArray=function(a){if(0==a.length)this.write1(77);else{this.write1(91);for(var g=0;g<a.length;++g)this.writeObject(a[g]);this.write1(93)}};
R.prototype.writeObject=function(a){switch(typeof a){case "string":this.writeString(a);break;case "number":this.writeNumber(a);break;case "bigint":q(this,new BigInteger(a.toString(16),16));break;case "boolean":this.write1(a?84:70);break;case "undefined":this.write1(85);break;case "object":if(null===a)this.write1(78);else if(Object.prototype.hasOwnProperty.call(a,"toOpaSO")&&"function"==typeof a.toOpaSO)a.toOpaSO(this);else if(Array.isArray(a))this.writeArray(a);else if(a===D.SORTMAX_OBJ)this.write1(90);
else if(a instanceof BigInteger)q(this,a);else if(a instanceof P)e(this,a);else if("Uint8Array"==a.constructor.name||"Buffer"==a.constructor.name)0==a.length?this.write1(65):(d(this,66,a.length),this.write(a));else throw Error("unsupported object type "+a.constructor.name);break;default:throw Error("unsupported type "+typeof a);}}})();function ea(c){var d=typeof c;if("object"==d)return null===c?"null":Array.isArray(c)?"Array":c===D.SORTMAX_OBJ?"SORTMAX":c instanceof BigInteger?"BigInteger":c instanceof P?"BigDec":"Uint8Array"==c.constructor.name?"Uint8Array":"Buffer"==c.constructor.name?"Buffer":"object";if("string"==d||"number"==d||"boolean"==d||"undefined"==d||"bigint"==d)return d;throw Error("unknown object");}function S(){}
(function(){function c(f,n){var q="",e;if("number"===typeof f)for(e=0;e<f*n;++e)q+=" ";else if("string"===typeof f)for(e=0;e<n;++e)q+=f;return q}function d(f,n,q){var e=ea(f);switch(e){case "undefined":case "null":return e;case "number":return 0==f&&-Infinity==1/f?"-0":f.toString();case "Uint8Array":case "Buffer":n="'";for(q=0;q<f.length;++q)if(e=f[q],32<=e&&127>e){if(92==e||39==e)n+="\\";n+=String.fromCharCode(e)}else 9==e?n+="\\t":10==e?n+="\\n":13==e?n+="\\r":(n+="\\x",16>e&&(n+="0"),n+=e.toString(16));
return n+"'";case "string":return JSON.stringify(f);case "Array":if(0==f.length)return"[]";q=q?q:0;e=[];for(var r=0;r<f.length;++r)e[r]=d(f[r],n,q+1);if(!n)return"["+e.join(",")+"]";f=c(n,q);n=c(n,q+1);return"[\n"+n+e.join(",\n"+n)+"\n"+f+"]"}if("function"===typeof f.toString)return f.toString();throw Error("unhandled case in switch");}S=function(f,n){return d(f,n,0)}})();function T(){}"function"==typeof Map?T=Map:(T=function(){this.vals={}},T.prototype.get=function(c){return this.vals[c]},T.prototype.set=function(c,d){this.vals[c]=d},T.prototype.delete=function(c){var d=c in this.vals;delete this.vals[c];return d},T.prototype.forEach=function(c){for(var d in this.vals)c(this.vals[d],d,this)},T.prototype.clear=function(){this.vals={}});function U(c){console&&console.log&&console.log(c)}function W(c,d,f){try{null!=d&&d.apply(c,f)}catch(n){U(n)}}
function X(c,d){W(c.mConfig,c.mConfig.clientErrorHandler,[d]);W(c.o,c.o.close)}function Y(){this.sendBuffLen=4096}Y.prototype.unknownIdHandler=function(c){U("unknown async id: "+S(c))};Y.prototype.uncaughtExceptionHandler=function(c){U("uncaught exception: "+(c||""))};Y.prototype.clientErrorHandler=function(c){U("client error: "+(c||""))};
function Z(c,d){d=d||new Y;this.o=c;this.s=new R(c,d.sendBuffLen);this.id=0;this.mMainCallbacks=new M;this.mAsyncCallbacks=new T;this.mParser=new Q;this.mBuff=new Q.Buff;this.mTimeout=null;this.mFlushScheduled=!1;this.mConfig=d}
(function(){function c(e){try{null!==e.mTimeout&&(clearTimeout(e.mTimeout),e.mFlushScheduled=!1,e.mTimeout=null),e.s.flush()}catch(r){X(e,r)}}function d(e){e.mFlushScheduled||(e.mTimeout=setTimeout(function(){e.mFlushScheduled=!1;e.mTimeout=null;c(e)},0),e.mFlushScheduled=!0)}function f(e,r,v,w){try{e.s.write1(91);e.s.writeObject(r);e.s.writeObject(v);if(w)for(r=0;r<w.length;++r)e.s.writeObject(w[r]);e.s.write1(93);d(e)}catch(B){X(e,B)}}function n(e,r,v){null==v?e.mAsyncCallbacks.delete(r):e.mAsyncCallbacks.set(r,
v)}function q(e,r,v,w){try{r(v,w)}catch(B){W(e.mConfig,e.mConfig.uncaughtExceptionHandler,[B])}}Z.prototype.flush=function(){c(this)};Z.prototype.call=function(e,r,v){v?(this.mMainCallbacks.push(v),f(this,null,e,r)):f(this,!1,e,r)};Z.prototype.registerCB=function(e,r){if("string"!=typeof e)throw Error("id must be a string");n(this,e,r)};Z.prototype.callID=function(e,r,v){if("string"!=typeof e)throw Error("id must be a string");f(this,e,r,v)};Z.prototype.callA=function(e,r,v){var w=this,B=++w.id;n(w,
B,function(a,g){n(w,B,null);q(w,v,a,g)});f(w,B,e,r)};Z.prototype.onRecv=function(e){try{for(this.mBuff.data=e,this.mBuff.idx=0,this.mBuff.len=e.length;;){var r=this.mParser.parseNext(this.mBuff);if(null==r)break;e=void 0;var v=r;if(2>v.length||3<v.length)throw Error("response array is wrong length");var w=v[0];null!==w&&void 0!==w?(e=this.mAsyncCallbacks.get(w),null!=e&&k(w)&&0<w&&this.mAsyncCallbacks.delete(w)):e=this.mMainCallbacks.shift();if(null!=e)q(this,e,2<v.length?v[2]:null,v[1]);else{if(null===
w||void 0===w)throw Error("received extraneous null-async-id response");W(this.mConfig,this.mConfig.unknownIdHandler,v)}}}catch(B){X(this,B)}};Z.prototype.onClose=function(){for(var e=this,r=e.mMainCallbacks,v=[D.ERR_CLOSED];0<r.size();)q(e,r.shift(),v);r=e.mAsyncCallbacks;r.forEach(function(w){q(e,w,v)});r.clear()}})();(function(){function c(f){this.s=f;this.c=null;this.closed=!1}c.prototype.write=function(f){var n=this.s,q=n.send;if(ArrayBuffer.prototype.slice)f=f.buffer.slice(f.byteOffset,f.byteLength+f.byteOffset);else{var e=new ArrayBuffer(f.byteLength);(new Uint8Array(e)).set(f);f=e}q.call(n,f);return!0};c.prototype.flush=function(){};c.prototype.close=function(){this.closed=!0;this.s.close();if(this.c)this.c.onClose()};var d={};d.BigDec=P;d.BigDecimal=P;d.BigInteger=BigInteger;d.ClientConfig=Y;d.EventClient=
Z;d.newClient=function(f,n){f.binaryType="arraybuffer";var q=new c(f),e=new Z(q,n);q.c=e;f.addEventListener("message",function(r){try{if(!(r.data instanceof ArrayBuffer))throw Error("event.data is not instanceof ArrayBuffer; server is using text frames?");e.onRecv(new Uint8Array(r.data))}catch(v){X(e,v)}});f.addEventListener("close",function(){q.close()});return e};d.OpaDef=D;d.opaType=ea;d.PartialParser=Q;d.Queue=M;d.RoundingMode=N;d.Serializer=R;d.stringify=S;d.version="0.1.59";window.Opatomic=
d})();
}());
