// Minimized and bundled source code for opatomic client. see https://github.com/opatomic/opac-js for more info

/* BigInteger (http://www-cs-students.stanford.edu/~tjw/jsbn/) LICENSE file: */
/*
Licensing
---------

This software is covered under the following copyright:

 * Copyright (c) 2003-2005  Tom Wu
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * In addition, the following condition applies:
 *
 * All redistributions must retain an intact copy of this copyright notice
 * and disclaimer.

Address all questions regarding this license to:

  Tom Wu
  tjw@cs.Stanford.EDU
*/



(function(){var BigInteger=function(){function e(a,b,c){null!=a&&("number"==typeof a?this.fromNumber(a,b,c):null==b&&"string"!=typeof a?this.fromString(a,256):this.fromString(a,b))}function l(){return new e(null)}function F(a,b,c,d,h,e){for(;0<=--e;){var f=b*this[a++]+c[d]+h;h=Math.floor(f/67108864);c[d++]=f&67108863}return h}function G(a,b,c,d,h,e){var f=b&32767;for(b>>=15;0<=--e;){var k=this[a]&32767,l=this[a++]>>15,q=b*k+l*f;k=f*k+((q&32767)<<15)+c[d]+(h&1073741823);h=(k>>>30)+(q>>>15)+b*l+(h>>>30);c[d++]=
k&1073741823}return h}function H(a,b,c,d,e,f){var h=b&16383;for(b>>=14;0<=--f;){var k=this[a]&16383,l=this[a++]>>14,q=b*k+l*h;k=h*k+((q&16383)<<14)+c[d]+e;e=(k>>28)+(q>>14)+b*l;c[d++]=k&268435455}return e}function B(a,b){a=y[a.charCodeAt(b)];return null==a?-1:a}function r(a){var b=l();b.fromInt(a);return b}function z(a){var b=1,c;0!=(c=a>>>16)&&(a=c,b+=16);0!=(c=a>>8)&&(a=c,b+=8);0!=(c=a>>4)&&(a=c,b+=4);0!=(c=a>>2)&&(a=c,b+=2);0!=a>>1&&(b+=1);return b}function u(a){this.m=a}function v(a){this.m=a;
this.mp=a.invDigit();this.mpl=this.mp&32767;this.mph=this.mp>>15;this.um=(1<<a.DB-15)-1;this.mt2=2*a.t}function I(a,b){return a&b}function A(a,b){return a|b}function C(a,b){return a^b}function D(a,b){return a&~b}function x(){}function E(a){return a}function w(a){this.r2=l();this.q3=l();e.ONE.dlShiftTo(2*a.t,this.r2);this.mu=this.r2.divide(a);this.m=a}if("Microsoft Internet Explorer"==navigator.appName){e.prototype.am=G;var n=30}else"Netscape"!=navigator.appName?(e.prototype.am=F,n=26):(e.prototype.am=
H,n=28);e.prototype.DB=n;e.prototype.DM=(1<<n)-1;e.prototype.DV=1<<n;e.prototype.FV=Math.pow(2,52);e.prototype.F1=52-n;e.prototype.F2=2*n-52;var y=[],p;n=48;for(p=0;9>=p;++p)y[n++]=p;n=97;for(p=10;36>p;++p)y[n++]=p;n=65;for(p=10;36>p;++p)y[n++]=p;u.prototype.convert=function(a){return 0>a.s||0<=a.compareTo(this.m)?a.mod(this.m):a};u.prototype.revert=function(a){return a};u.prototype.reduce=function(a){a.divRemTo(this.m,null,a)};u.prototype.mulTo=function(a,b,c){a.multiplyTo(b,c);this.reduce(c)};u.prototype.sqrTo=
function(a,b){a.squareTo(b);this.reduce(b)};v.prototype.convert=function(a){var b=l();a.abs().dlShiftTo(this.m.t,b);b.divRemTo(this.m,null,b);0>a.s&&0<b.compareTo(e.ZERO)&&this.m.subTo(b,b);return b};v.prototype.revert=function(a){var b=l();a.copyTo(b);this.reduce(b);return b};v.prototype.reduce=function(a){for(;a.t<=this.mt2;)a[a.t++]=0;for(var b=0;b<this.m.t;++b){var c=a[b]&32767,d=c*this.mpl+((c*this.mph+(a[b]>>15)*this.mpl&this.um)<<15)&a.DM;c=b+this.m.t;for(a[c]+=this.m.am(0,d,a,b,0,this.m.t);a[c]>=
a.DV;)a[c]-=a.DV,a[++c]++}a.clamp();a.drShiftTo(this.m.t,a);0<=a.compareTo(this.m)&&a.subTo(this.m,a)};v.prototype.mulTo=function(a,b,c){a.multiplyTo(b,c);this.reduce(c)};v.prototype.sqrTo=function(a,b){a.squareTo(b);this.reduce(b)};e.prototype.copyTo=function(a){for(var b=this.t-1;0<=b;--b)a[b]=this[b];a.t=this.t;a.s=this.s};e.prototype.fromInt=function(a){this.t=1;this.s=0>a?-1:0;0<a?this[0]=a:-1>a?this[0]=a+this.DV:this.t=0};e.prototype.fromString=function(a,b){if(16==b)b=4;else if(8==b)b=3;else if(256==
b)b=8;else if(2==b)b=1;else if(32==b)b=5;else if(4==b)b=2;else{this.fromRadix(a,b);return}this.s=this.t=0;for(var c=a.length,d=!1,h=0;0<=--c;){var f=8==b?a[c]&255:B(a,c);0>f?"-"==a.charAt(c)&&(d=!0):(d=!1,0==h?this[this.t++]=f:h+b>this.DB?(this[this.t-1]|=(f&(1<<this.DB-h)-1)<<h,this[this.t++]=f>>this.DB-h):this[this.t-1]|=f<<h,h+=b,h>=this.DB&&(h-=this.DB))}8==b&&0!=(a[0]&128)&&(this.s=-1,0<h&&(this[this.t-1]|=(1<<this.DB-h)-1<<h));this.clamp();d&&e.ZERO.subTo(this,this)};e.prototype.clamp=function(){for(var a=
this.s&this.DM;0<this.t&&this[this.t-1]==a;)--this.t};e.prototype.dlShiftTo=function(a,b){var c;for(c=this.t-1;0<=c;--c)b[c+a]=this[c];for(c=a-1;0<=c;--c)b[c]=0;b.t=this.t+a;b.s=this.s};e.prototype.drShiftTo=function(a,b){for(var c=a;c<this.t;++c)b[c-a]=this[c];b.t=Math.max(this.t-a,0);b.s=this.s};e.prototype.lShiftTo=function(a,b){var c=a%this.DB,d=this.DB-c,e=(1<<d)-1;a=Math.floor(a/this.DB);var f=this.s<<c&this.DM,g;for(g=this.t-1;0<=g;--g)b[g+a+1]=this[g]>>d|f,f=(this[g]&e)<<c;for(g=a-1;0<=g;--g)b[g]=
0;b[a]=f;b.t=this.t+a+1;b.s=this.s;b.clamp()};e.prototype.rShiftTo=function(a,b){b.s=this.s;var c=Math.floor(a/this.DB);if(c>=this.t)b.t=0;else{a%=this.DB;var d=this.DB-a,e=(1<<a)-1;b[0]=this[c]>>a;for(var f=c+1;f<this.t;++f)b[f-c-1]|=(this[f]&e)<<d,b[f-c]=this[f]>>a;0<a&&(b[this.t-c-1]|=(this.s&e)<<d);b.t=this.t-c;b.clamp()}};e.prototype.subTo=function(a,b){for(var c=0,d=0,e=Math.min(a.t,this.t);c<e;)d+=this[c]-a[c],b[c++]=d&this.DM,d>>=this.DB;if(a.t<this.t){for(d-=a.s;c<this.t;)d+=this[c],b[c++]=
d&this.DM,d>>=this.DB;d+=this.s}else{for(d+=this.s;c<a.t;)d-=a[c],b[c++]=d&this.DM,d>>=this.DB;d-=a.s}b.s=0>d?-1:0;-1>d?b[c++]=this.DV+d:0<d&&(b[c++]=d);b.t=c;b.clamp()};e.prototype.multiplyTo=function(a,b){var c=this.abs(),d=a.abs(),h=c.t;for(b.t=h+d.t;0<=--h;)b[h]=0;for(h=0;h<d.t;++h)b[h+c.t]=c.am(0,d[h],b,h,0,c.t);b.s=0;b.clamp();this.s!=a.s&&e.ZERO.subTo(b,b)};e.prototype.squareTo=function(a){for(var b=this.abs(),c=a.t=2*b.t;0<=--c;)a[c]=0;for(c=0;c<b.t-1;++c){var d=b.am(c,b[c],a,2*c,0,1);(a[c+
b.t]+=b.am(c+1,2*b[c],a,2*c+1,d,b.t-c-1))>=b.DV&&(a[c+b.t]-=b.DV,a[c+b.t+1]=1)}0<a.t&&(a[a.t-1]+=b.am(c,b[c],a,2*c,0,1));a.s=0;a.clamp()};e.prototype.divRemTo=function(a,b,c){var d=a.abs();if(!(0>=d.t)){var h=this.abs();if(h.t<d.t)null!=b&&b.fromInt(0),null!=c&&this.copyTo(c);else{null==c&&(c=l());var f=l(),g=this.s;a=a.s;var k=this.DB-z(d[d.t-1]);0<k?(d.lShiftTo(k,f),h.lShiftTo(k,c)):(d.copyTo(f),h.copyTo(c));d=f.t;h=f[d-1];if(0!=h){var m=h*(1<<this.F1)+(1<d?f[d-2]>>this.F2:0),q=this.FV/m;m=(1<<
this.F1)/m;var n=1<<this.F2,t=c.t,p=t-d,r=null==b?l():b;f.dlShiftTo(p,r);0<=c.compareTo(r)&&(c[c.t++]=1,c.subTo(r,c));e.ONE.dlShiftTo(d,r);for(r.subTo(f,f);f.t<d;)f[f.t++]=0;for(;0<=--p;){var u=c[--t]==h?this.DM:Math.floor(c[t]*q+(c[t-1]+n)*m);if((c[t]+=f.am(0,u,c,p,0,d))<u)for(f.dlShiftTo(p,r),c.subTo(r,c);c[t]<--u;)c.subTo(r,c)}null!=b&&(c.drShiftTo(d,b),g!=a&&e.ZERO.subTo(b,b));c.t=d;c.clamp();0<k&&c.rShiftTo(k,c);0>g&&e.ZERO.subTo(c,c)}}}};e.prototype.invDigit=function(){if(1>this.t)return 0;
var a=this[0];if(0==(a&1))return 0;var b=a&3;b=b*(2-(a&15)*b)&15;b=b*(2-(a&255)*b)&255;b=b*(2-((a&65535)*b&65535))&65535;b=b*(2-a*b%this.DV)%this.DV;return 0<b?this.DV-b:-b};e.prototype.isEven=function(){return 0==(0<this.t?this[0]&1:this.s)};e.prototype.exp=function(a,b){if(4294967295<a||1>a)return e.ONE;var c=l(),d=l(),h=b.convert(this),f=z(a)-1;for(h.copyTo(c);0<=--f;)if(b.sqrTo(c,d),0<(a&1<<f))b.mulTo(d,h,c);else{var g=c;c=d;d=g}return b.revert(c)};e.prototype.toString=function(a){if(0>this.s)return"-"+
this.negate().toString(a);if(16==a)a=4;else if(8==a)a=3;else if(2==a)a=1;else if(32==a)a=5;else if(4==a)a=2;else return this.toRadix(a);var b=(1<<a)-1,c,d=!1,e="",f=this.t,g=this.DB-f*this.DB%a;if(0<f--)for(g<this.DB&&0<(c=this[f]>>g)&&(d=!0,e="0123456789abcdefghijklmnopqrstuvwxyz".charAt(c));0<=f;)g<a?(c=(this[f]&(1<<g)-1)<<a-g,c|=this[--f]>>(g+=this.DB-a)):(c=this[f]>>(g-=a)&b,0>=g&&(g+=this.DB,--f)),0<c&&(d=!0),d&&(e+="0123456789abcdefghijklmnopqrstuvwxyz".charAt(c));return d?e:"0"};e.prototype.negate=
function(){var a=l();e.ZERO.subTo(this,a);return a};e.prototype.abs=function(){return 0>this.s?this.negate():this};e.prototype.compareTo=function(a){var b=this.s-a.s;if(0!=b)return b;var c=this.t;b=c-a.t;if(0!=b)return 0>this.s?-b:b;for(;0<=--c;)if(0!=(b=this[c]-a[c]))return b;return 0};e.prototype.bitLength=function(){return 0>=this.t?0:this.DB*(this.t-1)+z(this[this.t-1]^this.s&this.DM)};e.prototype.mod=function(a){var b=l();this.abs().divRemTo(a,null,b);0>this.s&&0<b.compareTo(e.ZERO)&&a.subTo(b,
b);return b};e.prototype.modPowInt=function(a,b){b=256>a||b.isEven()?new u(b):new v(b);return this.exp(a,b)};e.ZERO=r(0);e.ONE=r(1);x.prototype.convert=E;x.prototype.revert=E;x.prototype.mulTo=function(a,b,c){a.multiplyTo(b,c)};x.prototype.sqrTo=function(a,b){a.squareTo(b)};w.prototype.convert=function(a){if(0>a.s||a.t>2*this.m.t)return a.mod(this.m);if(0>a.compareTo(this.m))return a;var b=l();a.copyTo(b);this.reduce(b);return b};w.prototype.revert=function(a){return a};w.prototype.reduce=function(a){a.drShiftTo(this.m.t-
1,this.r2);a.t>this.m.t+1&&(a.t=this.m.t+1,a.clamp());this.mu.multiplyUpperTo(this.r2,this.m.t+1,this.q3);for(this.m.multiplyLowerTo(this.q3,this.m.t+1,this.r2);0>a.compareTo(this.r2);)a.dAddOffset(1,this.m.t+1);for(a.subTo(this.r2,a);0<=a.compareTo(this.m);)a.subTo(this.m,a)};w.prototype.mulTo=function(a,b,c){a.multiplyTo(b,c);this.reduce(c)};w.prototype.sqrTo=function(a,b){a.squareTo(b);this.reduce(b)};var m=[2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,
113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,907,
911,919,929,937,941,947,953,967,971,977,983,991,997],J=67108864/m[m.length-1];e.prototype.chunkSize=function(a){return Math.floor(Math.LN2*this.DB/Math.log(a))};e.prototype.toRadix=function(a){null==a&&(a=10);if(0==this.signum()||2>a||36<a)return"0";var b=this.chunkSize(a);b=Math.pow(a,b);var c=r(b),d=l(),e=l(),f="";for(this.divRemTo(c,d,e);0<d.signum();)f=(b+e.intValue()).toString(a).substr(1)+f,d.divRemTo(c,d,e);return e.intValue().toString(a)+f};e.prototype.fromRadix=function(a,b){this.fromInt(0);
null==b&&(b=10);for(var c=this.chunkSize(b),d=Math.pow(b,c),h=!1,f=0,g=0,k=0;k<a.length;++k){var l=B(a,k);0>l?"-"==a.charAt(k)&&0==this.signum()&&(h=!0):(g=b*g+l,++f>=c&&(this.dMultiply(d),this.dAddOffset(g,0),g=f=0))}0<f&&(this.dMultiply(Math.pow(b,f)),this.dAddOffset(g,0));h&&e.ZERO.subTo(this,this)};e.prototype.fromNumber=function(a,b,c){if("number"==typeof b)if(2>a)this.fromInt(1);else for(this.fromNumber(a,c),this.testBit(a-1)||this.bitwiseTo(e.ONE.shiftLeft(a-1),A,this),this.isEven()&&this.dAddOffset(1,
0);!this.isProbablePrime(b);)this.dAddOffset(2,0),this.bitLength()>a&&this.subTo(e.ONE.shiftLeft(a-1),this);else{c=[];var d=a&7;c.length=(a>>3)+1;b.nextBytes(c);c[0]=0<d?c[0]&(1<<d)-1:0;this.fromString(c,256)}};e.prototype.bitwiseTo=function(a,b,c){var d,e=Math.min(a.t,this.t);for(d=0;d<e;++d)c[d]=b(this[d],a[d]);if(a.t<this.t){var f=a.s&this.DM;for(d=e;d<this.t;++d)c[d]=b(this[d],f);c.t=this.t}else{f=this.s&this.DM;for(d=e;d<a.t;++d)c[d]=b(f,a[d]);c.t=a.t}c.s=b(this.s,a.s);c.clamp()};e.prototype.changeBit=
function(a,b){a=e.ONE.shiftLeft(a);this.bitwiseTo(a,b,a);return a};e.prototype.addTo=function(a,b){for(var c=0,d=0,e=Math.min(a.t,this.t);c<e;)d+=this[c]+a[c],b[c++]=d&this.DM,d>>=this.DB;if(a.t<this.t){for(d+=a.s;c<this.t;)d+=this[c],b[c++]=d&this.DM,d>>=this.DB;d+=this.s}else{for(d+=this.s;c<a.t;)d+=a[c],b[c++]=d&this.DM,d>>=this.DB;d+=a.s}b.s=0>d?-1:0;0<d?b[c++]=d:-1>d&&(b[c++]=this.DV+d);b.t=c;b.clamp()};e.prototype.dMultiply=function(a){this[this.t]=this.am(0,a-1,this,0,0,this.t);++this.t;this.clamp()};
e.prototype.dAddOffset=function(a,b){if(0!=a){for(;this.t<=b;)this[this.t++]=0;for(this[b]+=a;this[b]>=this.DV;)this[b]-=this.DV,++b>=this.t&&(this[this.t++]=0),++this[b]}};e.prototype.multiplyLowerTo=function(a,b,c){var d=Math.min(this.t+a.t,b);c.s=0;for(c.t=d;0<d;)c[--d]=0;var e;for(e=c.t-this.t;d<e;++d)c[d+this.t]=this.am(0,a[d],c,d,0,this.t);for(e=Math.min(a.t,b);d<e;++d)this.am(0,a[d],c,d,0,b-d);c.clamp()};e.prototype.multiplyUpperTo=function(a,b,c){--b;var d=c.t=this.t+a.t-b;for(c.s=0;0<=--d;)c[d]=
0;for(d=Math.max(b-this.t,0);d<a.t;++d)c[this.t+d-b]=this.am(b-d,a[d],c,0,0,this.t+d-b);c.clamp();c.drShiftTo(1,c)};e.prototype.modInt=function(a){if(0>=a)return 0;var b=this.DV%a,c=0>this.s?a-1:0;if(0<this.t)if(0==b)c=this[0]%a;else for(var d=this.t-1;0<=d;--d)c=(b*c+this[d])%a;return c};e.prototype.millerRabin=function(a){var b=this.subtract(e.ONE),c=b.getLowestSetBit();if(0>=c)return!1;var d=b.shiftRight(c);a=a+1>>1;a>m.length&&(a=m.length);for(var h=l(),f=0;f<a;++f){h.fromInt(m[Math.floor(Math.random()*
m.length)]);var g=h.modPow(d,this);if(0!=g.compareTo(e.ONE)&&0!=g.compareTo(b)){for(var k=1;k++<c&&0!=g.compareTo(b);)if(g=g.modPowInt(2,this),0==g.compareTo(e.ONE))return!1;if(0!=g.compareTo(b))return!1}}return!0};e.prototype.clone=function(){var a=l();this.copyTo(a);return a};e.prototype.intValue=function(){if(0>this.s){if(1==this.t)return this[0]-this.DV;if(0==this.t)return-1}else{if(1==this.t)return this[0];if(0==this.t)return 0}return(this[1]&(1<<32-this.DB)-1)<<this.DB|this[0]};e.prototype.byteValue=
function(){return 0==this.t?this.s:this[0]<<24>>24};e.prototype.shortValue=function(){return 0==this.t?this.s:this[0]<<16>>16};e.prototype.signum=function(){return 0>this.s?-1:0>=this.t||1==this.t&&0>=this[0]?0:1};e.prototype.toByteArray=function(){var a=this.t,b=[];b[0]=this.s;var c=this.DB-a*this.DB%8,d,e=0;if(0<a--)for(c<this.DB&&(d=this[a]>>c)!=(this.s&this.DM)>>c&&(b[e++]=d|this.s<<this.DB-c);0<=a;)if(8>c?(d=(this[a]&(1<<c)-1)<<8-c,d|=this[--a]>>(c+=this.DB-8)):(d=this[a]>>(c-=8)&255,0>=c&&(c+=
this.DB,--a)),0!=(d&128)&&(d|=-256),0==e&&(this.s&128)!=(d&128)&&++e,0<e||d!=this.s)b[e++]=d;return b};e.prototype.equals=function(a){return 0==this.compareTo(a)};e.prototype.min=function(a){return 0>this.compareTo(a)?this:a};e.prototype.max=function(a){return 0<this.compareTo(a)?this:a};e.prototype.and=function(a){var b=l();this.bitwiseTo(a,I,b);return b};e.prototype.or=function(a){var b=l();this.bitwiseTo(a,A,b);return b};e.prototype.xor=function(a){var b=l();this.bitwiseTo(a,C,b);return b};e.prototype.andNot=
function(a){var b=l();this.bitwiseTo(a,D,b);return b};e.prototype.not=function(){for(var a=l(),b=0;b<this.t;++b)a[b]=this.DM&~this[b];a.t=this.t;a.s=~this.s;return a};e.prototype.shiftLeft=function(a){var b=l();0>a?this.rShiftTo(-a,b):this.lShiftTo(a,b);return b};e.prototype.shiftRight=function(a){var b=l();0>a?this.lShiftTo(-a,b):this.rShiftTo(a,b);return b};e.prototype.getLowestSetBit=function(){for(var a=0;a<this.t;++a)if(0!=this[a]){var b=a*this.DB;a=this[a];if(0==a)a=-1;else{var c=0;0==(a&65535)&&
(a>>=16,c+=16);0==(a&255)&&(a>>=8,c+=8);0==(a&15)&&(a>>=4,c+=4);0==(a&3)&&(a>>=2,c+=2);0==(a&1)&&++c;a=c}return b+a}return 0>this.s?this.t*this.DB:-1};e.prototype.bitCount=function(){for(var a=0,b=this.s&this.DM,c=0;c<this.t;++c){for(var d=this[c]^b,e=0;0!=d;)d&=d-1,++e;a+=e}return a};e.prototype.testBit=function(a){var b=Math.floor(a/this.DB);return b>=this.t?0!=this.s:0!=(this[b]&1<<a%this.DB)};e.prototype.setBit=function(a){return this.changeBit(a,A)};e.prototype.clearBit=function(a){return this.changeBit(a,
D)};e.prototype.flipBit=function(a){return this.changeBit(a,C)};e.prototype.add=function(a){var b=l();this.addTo(a,b);return b};e.prototype.subtract=function(a){var b=l();this.subTo(a,b);return b};e.prototype.multiply=function(a){var b=l();this.multiplyTo(a,b);return b};e.prototype.divide=function(a){var b=l();this.divRemTo(a,b,null);return b};e.prototype.remainder=function(a){var b=l();this.divRemTo(a,null,b);return b};e.prototype.divideAndRemainder=function(a){var b=l(),c=l();this.divRemTo(a,b,
c);return[b,c]};e.prototype.modPow=function(a,b){var c=a.bitLength(),d=r(1);if(0>=c)return d;var e=18>c?1:48>c?3:144>c?4:768>c?5:6;b=8>c?new u(b):b.isEven()?new w(b):new v(b);var f=[],g=3,k=e-1,m=(1<<e)-1;f[1]=b.convert(this);if(1<e)for(c=l(),b.sqrTo(f[1],c);g<=m;)f[g]=l(),b.mulTo(c,f[g-2],f[g]),g+=2;var q=a.t-1,p=!0,t=l();for(c=z(a[q])-1;0<=q;){if(c>=k)var n=a[q]>>c-k&m;else n=(a[q]&(1<<c+1)-1)<<k-c,0<q&&(n|=a[q-1]>>this.DB+c-k);for(g=e;0==(n&1);)n>>=1,--g;0>(c-=g)&&(c+=this.DB,--q);if(p)f[n].copyTo(d),
p=!1;else{for(;1<g;)b.sqrTo(d,t),b.sqrTo(t,d),g-=2;0<g?b.sqrTo(d,t):(g=d,d=t,t=g);b.mulTo(t,f[n],d)}for(;0<=q&&0==(a[q]&1<<c);)b.sqrTo(d,t),g=d,d=t,t=g,0>--c&&(c=this.DB-1,--q)}return b.revert(d)};e.prototype.modInverse=function(a){var b=a.isEven();if(this.isEven()&&b||0==a.signum())return e.ZERO;for(var c=a.clone(),d=this.clone(),h=r(1),f=r(0),g=r(0),k=r(1);0!=c.signum();){for(;c.isEven();)c.rShiftTo(1,c),b?(h.isEven()&&f.isEven()||(h.addTo(this,h),f.subTo(a,f)),h.rShiftTo(1,h)):f.isEven()||f.subTo(a,
f),f.rShiftTo(1,f);for(;d.isEven();)d.rShiftTo(1,d),b?(g.isEven()&&k.isEven()||(g.addTo(this,g),k.subTo(a,k)),g.rShiftTo(1,g)):k.isEven()||k.subTo(a,k),k.rShiftTo(1,k);0<=c.compareTo(d)?(c.subTo(d,c),b&&h.subTo(g,h),f.subTo(k,f)):(d.subTo(c,d),b&&g.subTo(h,g),k.subTo(f,k))}if(0!=d.compareTo(e.ONE))return e.ZERO;if(0<=k.compareTo(a))return k.subtract(a);if(0>k.signum())k.addTo(a,k);else return k;return 0>k.signum()?k.add(a):k};e.prototype.pow=function(a){return this.exp(a,new x)};e.prototype.gcd=function(a){var b=
0>this.s?this.negate():this.clone();a=0>a.s?a.negate():a.clone();if(0>b.compareTo(a)){var c=b;b=a;a=c}c=b.getLowestSetBit();var d=a.getLowestSetBit();if(0>d)return b;c<d&&(d=c);0<d&&(b.rShiftTo(d,b),a.rShiftTo(d,a));for(;0<b.signum();)0<(c=b.getLowestSetBit())&&b.rShiftTo(c,b),0<(c=a.getLowestSetBit())&&a.rShiftTo(c,a),0<=b.compareTo(a)?(b.subTo(a,b),b.rShiftTo(1,b)):(a.subTo(b,a),a.rShiftTo(1,a));0<d&&a.lShiftTo(d,a);return a};e.prototype.isProbablePrime=function(a){var b,c=this.abs();if(1==c.t&&
c[0]<=m[m.length-1]){for(b=0;b<m.length;++b)if(c[0]==m[b])return!0;return!1}if(c.isEven())return!1;for(b=1;b<m.length;){for(var d=m[b],e=b+1;e<m.length&&d<J;)d*=m[e++];for(d=c.modInt(d);b<e;)if(0==d%m[b++])return!1}return c.millerRabin(a)};e.prototype.square=function(){var a=l();this.squareTo(a);return a};return e}();
var m=new TextEncoder("utf-8"),n=new TextDecoder("utf-8");function r(c,d){if(d&&10>=d)throw"buffer len is too small";this.o=c;this.b=new Uint8Array(d?d:4096);this.i=0}
(function(){function c(e){0<e.i&&(e.o.write(e.i==e.b.length?e.b:e.b.subarray(0,e.i)),e.i=0)}function d(e,b,a){e.i+10>e.b.length&&c(e);for(0!=b&&(e.b[e.i++]=b);2147483647<a;)e.b[e.i++]=128|a%128,a=Math.floor(a/128);for(;127<a;)e.b[e.i++]=128|a&255,a>>>=7;e.b[e.i++]=a}function g(e,b,a){if(0>a.signum())BigInteger.ZERO.subTo(a,q),g(e,b,q);else{var c=a.bitLength();c=(c>>3)+(0==(c&7)?0:1);a=a.toByteArray();if(a.length!=c&&a.length!=c+1)throw"BigInteger.toByteArray() returned unexpected value";d(e,b,c);
for(b=a.length-c;b<a.length;++b)e.write1(a[b])}}function b(e,a,d){if(0>d.signum())BigInteger.ZERO.subTo(d,q),b(e,a,q);else{e.i+10>e.b.length&&c(e);0!=a&&(e.b[e.i++]=a);if(0<d.compareTo(y))for(d!=q&&(d.copyTo(q),d=q);0<d.compareTo(y);)e.b[e.i++]=128|d.byteValue()&127,d.rShiftTo(7,d);for(a=d.intValue();127<a;)e.b[e.i++]=128|a&255,a>>>=7;e.b[e.i++]=a}}function a(e,a){var d=a.signum();0==d?e.write1(79):0<d?0>=a.compareTo(h)?b(e,68,a):g(e,75,a):0<=a.compareTo(l)?b(e,69,a):g(e,76,a)}function f(e,c){if(0==
c.e)a(e,c.m);else{var f=0>c.e?!0:!1,t=0>c.e?0-c.e:c.e;0<c.signum()?0>=c.m.compareTo(h)?(d(e,f?73:71,t),b(e,0,c.m)):(d(e,f?88:86,t),g(e,0,c.m)):0<=c.m.compareTo(l)?(d(e,f?74:72,t),b(e,0,c.m)):(d(e,f?89:87,t),g(e,0,c.m))}}var h=new BigInteger("9223372036854775807"),l=h.negate(),y=new BigInteger("7FFFFFFF",16),q=new BigInteger(null);r.prototype.write1=function(e){this.i>=this.b.length&&c(this);this.b[this.i++]=e};r.prototype.write=function(e){if(e.length>this.b.length-this.i&&(c(this),e.length>=this.b.length)){this.o.write(e);
return}this.b.set(e,this.i);this.i+=e.length};r.prototype.flush=function(){c(this);"function"===typeof this.o.flush&&this.o.flush()};r.prototype.writeNumber=function(e){if(u(e))0<e?d(this,68,e):0==e?this.write1(79):d(this,69,0-e);else if(-Infinity===e)this.write1(80);else if(Infinity===e)this.write1(81);else{if("number"!=typeof e)throw"not a number";if(isNaN(e))throw"number is NaN; cannot be serialized";f(this,new v(e.toString()))}};r.prototype.writeString=function(e){if(0==e.length)this.write1(82);
else{var b;if(r.STR2BUF&&(b=r.STR2BUF.get(e))){d(this,83,b.length);this.write(b);return}if(1024>e.length){var a=e.length;b=0+a;for(var f=0;f<b;++f){var h=e.charCodeAt(f);if(!(128>h))if(2048>h)++a;else{if(!(55296>h||57343<h)&&56320>h&&f<b-1&&(h=e.charCodeAt(f+1),56320<=h&&57343>=h)){a+=2;++f;continue}a+=2}}d(this,83,a);b=e.length;a=this.i;f=this.b;for(h=0;h<b;++h){a+4>f.length&&(this.i=a,c(this),a=this.i,f=this.b);var g=e.charCodeAt(h);if(128>g)f[a++]=g;else if(2048>g)f[a++]=192|g>>6,f[a++]=128|g&
63;else if(55296>g||57343<g)f[a++]=224|g>>12,f[a++]=128|g>>6&63,f[a++]=128|g&63;else{if(56320>g&&h<b-1){var l=e.charCodeAt(h+1);if(56320<=l&&57343>=l){l=(g<<10)+l+-56613888;++h;f[a++]=240|l>>18;f[a++]=128|l>>12&63;f[a++]=128|l>>6&63;f[a++]=128|l&63;continue}}f[a++]=239;f[a++]=191;f[a++]=189}}this.i=a}else b=m.encode(e),d(this,83,b.length),this.write(b)}};r.prototype.writeArray=function(a){if(0==a.length)this.write1(77);else{this.write1(91);for(var e=0;e<a.length;++e)this.writeObject(a[e]);this.write1(93)}};
r.prototype.writeObject=function(e){switch(typeof e){case "string":this.writeString(e);break;case "number":this.writeNumber(e);break;case "bigint":a(this,new BigInteger(e.toString()));break;case "boolean":this.write1(e?84:70);break;case "undefined":this.write1(85);break;case "object":if(null===e)this.write1(78);else if(e.hasOwnProperty("toOpaSO")&&"function"==typeof e.toOpaSO)e.toOpaSO(this);else if(Array.isArray(e))this.writeArray(e);else if(e===w.SORTMAX_OBJ)this.write1(90);else if(e instanceof
BigInteger)a(this,e);else if(e instanceof v)f(this,e);else if("Uint8Array"==e.constructor.name||"Buffer"==e.constructor.name)0==e.length?this.write1(65):(d(this,66,e.length),this.write(e));else throw"unsupported object type "+e.constructor.name;break;default:throw"unsupported type "+typeof e;}};r.STR2BUF="undefined"==typeof Map?null:new Map})();var x=Number.isInteger||function(c){return"number"===typeof c&&isFinite(c)&&Math.floor(c)===c},u=Number.isSafeInteger||function(c){return x(c)&&-9007199254740991<=c&&9007199254740991>=c};
function A(c){var d=typeof c;if("object"==d)return null===c?"null":Array.isArray(c)?"Array":c===w.SORTMAX_OBJ?"SORTMAX":c instanceof BigInteger?"BigInteger":c instanceof v?"BigDec":"Uint8Array"==c.constructor.name?"Uint8Array":"Buffer"==c.constructor.name?"Buffer":"object";if("string"==d||"number"==d||"boolean"==d||"undefined"==d||"bigint"==d)return d;throw"unknown object";};function C(){this.totlen=0;this.tail=this.head=D(this.newChunkSize,null)}function D(c,d){c=Array(c);c.next=null;c.head=0;c.used=0;d&&(d.next=c);return c}C.prototype.push=function(c){var d=this.tail;d.used+1>=d.length&&(this.tail=d=D(this.newChunkSize,d));d[d.head+d.used&d.length-1]=c;d.used++;return++this.totlen};C.prototype.shift=function(){var c=this.head;if(0!=c.used){var d=c.head,g=c[d];c[d]=void 0;c.used--;0==c.used&&c.next?this.head=c.next:c.head=d+1&c.length-1;this.totlen--;return g}};
C.prototype.size=function(){return this.totlen};C.prototype.newChunkSize=64;function v(c,d){if("string"==typeof c){d=c.indexOf(".");var g=c.indexOf("e");0>g&&(g=c.indexOf("E"));if(0>g)this.m=new BigInteger(c),this.e=0;else if(this.m=new BigInteger(c.substring(0,g)),this.e=parseInt(c.substring(g+1),10),!u(this.e))throw'number string "'+c+'" cannot be parsed';0<=d&&(this.e-=0>g?c.length-d-1:g-d-1)}else this.m=c?c:new BigInteger(null),this.e=d?d:0}
(function(){function c(){return new v(new BigInteger(null),0)}function d(b,a){if(0>a)throw"invalid extension. must be >= 0";if(0==a)return b;for(var c=0>b.m.signum()?b.m.negate():b.m.clone(),d=a;0<d;--d)c.dMultiply(10);return new v(0>b.m.signum()?c.negate():c,b.e-a)}function g(b,a,c){if(b==c||a==c){var f=c.clone();g(b,a,f);f.copyTo(c)}else 0==b.signum()?b.copyTo(c):0==a.signum()?a.copyTo(c):(b.e>a.e?b=d(b,b.e-a.e):b.e<a.e&&(a=d(a,a.e-b.e)),b.m.multiplyTo(a.m,c.m),c.e=0==c.m.signum()?0:b.e+a.e)}v.prototype.abs=
function(){return 0>this.m.signum()?new v(this.m.abs(),this.e):this};v.prototype.add=function(b){var a=c(),f=this;0==b.signum()?f.copyTo(a):0==f.signum()?b.copyTo(a):(f.e>b.e?f=d(f,f.e-b.e):f.e<b.e&&(b=d(b,b.e-f.e)),f.m.addTo(b.m,a.m),a.e=0==a.m.signum()?0:f.e);return a};v.prototype.clone=function(){return new v(this.m.clone(),this.e)};v.prototype.compareTo=function(b){if(0>this.m.s){if(0<=b.m.s)return-1}else if(0>b.m.s)return 1;return this.e==b.e?this.m.compareTo(b.m):this.e>b.e?d(this,this.e-b.e).compareTo(b):
this.compareTo(d(b,b.e-this.e))};v.prototype.copyTo=function(b){this.m.copyTo(b.m);b.e=this.e};v.prototype.multiply=function(b){var a=c();g(this,b,a);return a};v.prototype.signum=function(){return this.m.signum()};v.prototype.subtract=function(b){var a=c(),f=this;0==b.signum()?f.copyTo(a):0==f.signum()?(BigInteger.ZERO.subTo(b.m,a.m),a.e=b.e):(f.e>b.e?f=d(f,f.e-b.e):f.e<b.e&&(b=d(b,b.e-f.e)),f.m.subTo(b.m,a.m),a.e=0==a.m.signum()?0:f.e);return a};v.prototype.toString=function(){var b=this.m.toString(),
a=this.e;if(0!=a){var c="-"==b.charAt(0);b=c?b.substring(1):b;if(0<a){if(5>=a)for(;0<a;--a)b+="0"}else if(-5<=b.length+a){for(;0>=b.length+a;)b="0"+b;a=b.length+a;b=b.substring(0,a)+"."+b.substring(a);a=0}0!=a&&1<b.length&&(a+=b.length-1,b=b.substring(0,1)+"."+b.substring(1));b=c?"-"+b:b;0!=a&&(b+="e"+a.toString())}return b}})();function E(){}"function"==typeof Map?E=Map:(E=function(){this.vals={}},E.prototype.get=function(c){return this.vals[c]},E.prototype.set=function(c,d){this.vals[c]=d},E.prototype.delete=function(c){var d=c in this.vals;delete this.vals[c];return d},E.prototype.forEach=function(c){for(var d in this.vals)c(this.vals[d],d,this)},E.prototype.clear=function(){this.vals={}});
function F(c){this.s=new r(c);this.id=0;this.mMainCallbacks=new C;this.mAsyncCallbacks=new E;this.mParser=new G;this.mBuff=new G.Buff;this.mTimeout=null;this.mFlushScheduled=!1}
(function(){function c(b){b.mFlushScheduled||(b.mTimeout=setTimeout(function(){b.mFlushScheduled=!1;b.mTimeout=null;b.s.flush()},0),b.mFlushScheduled=!0)}function d(b,a,d,g){b.s.write1(91);b.s.writeObject(a);b.s.writeObject(d);if(g)for(a=0;a<g.length;++a)b.s.writeObject(g[a]);b.s.write1(93);c(b)}function g(b,a,c){null==c?b.mAsyncCallbacks.delete(a):b.mAsyncCallbacks.set(a,c)}F.prototype.flush=function(){null!==this.mTimeout&&(clearTimeout(this.mTimeout),this.mFlushScheduled=!1,this.mTimeout=null);
this.s.flush()};F.prototype.call=function(b,a,c){c?(this.mMainCallbacks.push(c),d(this,null,b,a)):d(this,!1,b,a)};F.prototype.registerCB=function(b,a){if("string"!=typeof b)throw"id must be a string";g(this,b,a)};F.prototype.callID=function(b,a,c){if("string"!=typeof b)throw"id must be a string";d(this,b,a,c)};F.prototype.callA=function(b,a,c){var f=this,l=++f.id;g(f,l,function(a,b){g(f,l,null);c(a,b)});d(f,l,b,a)};F.prototype.onRecv=function(b){this.mBuff.data=b;this.mBuff.idx=0;for(this.mBuff.len=
b.length;;){b=this.mParser.parseNext(this.mBuff);if(null==b)break;var a=b;if(2>a.length||3<a.length)throw"response array is wrong length";var c=a[0];null!==c&&void 0!==c?(b=this.mAsyncCallbacks.get(c),null!=b&&x(c)&&0<c&&this.mAsyncCallbacks.delete(c)):b=this.mMainCallbacks.shift();null!=b?b(2<a.length?a[2]:null,a[1]):console.log&&console.log("unknown async id: "+c)}};F.prototype.onClose=function(){for(var b=this.mMainCallbacks;0<b.size();){var a=b.shift();a&&a(w.ERR_CLOSED)}b=this.mAsyncCallbacks;
b.forEach(function(a){a&&a(w.ERR_CLOSED)});b.clear()}})();var w={UNDEFINED:85,NULL:78,FALSE:70,TRUE:84,ZERO:79,NEGINF:80,POSINF:81,EMPTYBIN:65,EMPTYSTR:82,EMPTYARRAY:77,SORTMAX:90,POSVARINT:68,NEGVARINT:69,POSPOSVARDEC:71,POSNEGVARDEC:72,NEGPOSVARDEC:73,NEGNEGVARDEC:74,POSBIGINT:75,NEGBIGINT:76,POSPOSBIGDEC:86,POSNEGBIGDEC:87,NEGPOSBIGDEC:88,NEGNEGBIGDEC:89,BINLPVI:66,STRLPVI:83,ARRAYSTART:91,ARRAYEND:93};w.SORTMAX_OBJ=new function(){this.toString=function(){return"SORTMAX"}};w.ERR_CLOSED=-16394;function G(){}
(function(){function c(a,b){a.mState=13;throw b;}function d(a,b){null==a.mCurrCont&&c(a,"no array container");a.mCurrCont.push(b)}function g(a,b,c){a.mState=2;a.mNextState=c;a.mObjType=b;a.mVarintVal=0;a.mVarintMul=1;a.mVarintBitshift=0}function b(a,b){("number"!=typeof a.mVarintVal||2147483647<a.mVarintVal)&&c(a,"varint out of range");return b?0-a.mVarintVal:a.mVarintVal}function a(a,b){if(a){if("number"==typeof b)return 0-b;BigInteger.ZERO.subTo(b,b)}return b}function f(a,b,c){c.t=0;for(var e=c.s=
0;0<=--b;){var d=a[b]&255;0==e?c[c.t++]=d:e+8>c.DB?(c[c.t-1]|=(d&(1<<c.DB-e)-1)<<e,c[c.t++]=d>>c.DB-e):c[c.t-1]|=d<<e;e+=8;e>=c.DB&&(e-=c.DB)}c.clamp();return c}function h(a,b){a&&BigInteger.ZERO.subTo(b,b);return b}function l(a){if(0>a)return h(!0,l(0-a));if(0==a)return BigInteger.ZERO.clone();if(!u(a))throw"arg is not safe integer";var b=new BigInteger(null);b.s=0;b.t=1;b[0]=a&b.DM;a=Math.floor(a/b.DV);for(var c=1;0<a;++c)b[c]=a&b.DM,++b.t,a=Math.floor(a/b.DV);return b}function y(a){4096<a.mBytes.length&&
(a.mBytes=null)}var q=new BigInteger(null);G=function(){this.mContainers=[];this.mCurrCont=null;this.mState=1;this.mBytesLen=this.mBytesIdx=this.mObjType=this.mDecExp=this.mVarintBitshift=this.mVarintMul=this.mVarintVal=this.mNextState2=this.mNextState=0;this.mBytes=null};G.prototype.parseNext=function(e){var t=e.data,p=e.idx,B=e.idx+e.len;a:for(;;)switch(this.mState){case 1:if(p>=B)return e.idx=p,e.len=0,null;switch(t[p++]){case 85:d(this,void 0);continue;case 78:d(this,null);continue;case 70:d(this,
!1);continue;case 84:d(this,!0);continue;case 79:d(this,0);continue;case 80:d(this,-Infinity);continue;case 81:d(this,Infinity);continue;case 65:d(this,new Uint8Array(0));continue;case 82:d(this,"");continue;case 77:d(this,[]);continue;case 90:d(this,w.SORTMAX_OBJ);continue;case 69:g(this,69,3);continue;case 68:g(this,68,3);continue;case 76:g(this,76,9);this.mNextState2=6;continue;case 75:g(this,75,9);this.mNextState2=6;continue;case 71:g(this,71,4);continue;case 72:g(this,72,4);continue;case 73:g(this,
73,4);continue;case 74:g(this,74,4);continue;case 86:g(this,86,7);continue;case 87:g(this,87,7);continue;case 88:g(this,88,7);continue;case 89:g(this,89,7);continue;case 66:g(this,66,9);this.mNextState2=11;continue;case 83:g(this,83,9);this.mNextState2=12;continue;case 91:null!=this.mCurrCont&&this.mContainers.push(this.mCurrCont);this.mCurrCont=[];continue;case 93:null==this.mCurrCont&&c(this,"array end token when not in array");if(0==this.mContainers.length)return t=this.mCurrCont,this.mCurrCont=
null,e.idx=p,e.len=B-p,t;var k=this.mContainers.pop();k.push(this.mCurrCont);this.mCurrCont=k;continue;default:c(this,"unknown char")}case 2:for(;;){if(p>=B)return e.idx=p,e.len=0,null;var z=k=t[p++];if(28>this.mVarintBitshift)this.mVarintVal|=(z&127)<<this.mVarintBitshift,this.mVarintMul<<=7;else if(49>this.mVarintBitshift)this.mVarintVal+=(z&127)*this.mVarintMul,this.mVarintMul*=128;else{if(56<this.mVarintBitshift)throw"varint too big";49==this.mVarintBitshift&&(this.mVarintVal=l(this.mVarintVal));
q.fromInt(z&127);q.lShiftTo(this.mVarintBitshift,q);this.mVarintVal.addTo(q,this.mVarintVal)}this.mVarintBitshift+=7;if(0==(k&128)){this.mState=this.mNextState;continue a}}case 3:d(this,a(69==this.mObjType,this.mVarintVal));this.mState=1;continue;case 9:this.mBytesLen=b(this,!1);if(null==this.mBytes||this.mBytes.length<this.mBytesLen)this.mBytes=new Uint8Array(this.mBytesLen);this.mBytesIdx=0;this.mState=10;case 10:k=Math.min(B-p,this.mBytesLen-this.mBytesIdx);this.mBytes.set(t.subarray(p,p+k),this.mBytesIdx);
this.mBytesIdx+=k;p+=k;if(this.mBytesIdx<this.mBytesLen)return e.idx=p,e.len=0,null;this.mState=this.mNextState2;continue;case 6:d(this,h(76==this.mObjType,f(this.mBytes,this.mBytesLen,new BigInteger(null))));y(this);this.mState=1;continue;case 4:this.mDecExp=b(this,73==this.mObjType||74==this.mObjType);g(this,this.mObjType,5);continue;case 5:k=a(72==this.mObjType||74==this.mObjType,this.mVarintVal);k="number"==typeof k?l(k):k;d(this,new v(k,this.mDecExp));this.mState=1;continue;case 7:this.mDecExp=
b(this,88==this.mObjType||89==this.mObjType);g(this,this.mObjType,9);this.mNextState2=8;continue;case 8:k=h(87==this.mObjType||89==this.mObjType,f(this.mBytes,this.mBytesLen,new BigInteger(null)));d(this,new v(k,this.mDecExp));y(this);this.mState=1;continue;case 11:d(this,this.mBytes.subarray(0,this.mBytesLen));this.mBytes=null;this.mState=1;continue;case 12:k=this.mBytes.subarray(0,this.mBytesLen);k=(z=G.BUF2STR?G.BUF2STR.get(k):null)?z:n.decode(k);d(this,k);y(this);this.mState=1;continue;default:c(this,
"unknown state")}};G.BUF2STR="undefined"==typeof Map?null:new Map})();G.Buff=function(){this.data=null;this.len=this.idx=0};var H=window.Opatomic={};H.version="0.1.58";H.BigInteger=BigInteger;H.BigDec=v;H.OpaDef=w;
H.stringify=function(c,d){function g(a,b){var c="";if("number"===typeof a)for(var d=0;d<a*b;++d)c+=" ";else if("string"===typeof a)for(d=0;d<=b;++d)c+=a;return c}function b(a,c,d){switch(A(a)){case "undefined":return"undefined";case "null":return"null";case "Uint8Array":case "Buffer":var f="'";for(c=0;c<a.length;++c)if(d=a[c],32<=d&&127>d){if(92==d||39==d)f+="\\";f+=String.fromCharCode(d)}else 9==d?f+="\\t":10==d?f+="\\n":13==d?f+="\\r":(f+="\\x",16>d&&(f+="0"),f+=d.toString(16));return f+"'";case "string":return JSON.stringify(a);
case "Array":if(0==a.length)return"[]";d=d?d:0;f=[];for(var h=0;h<a.length;++h)f[h]=b(a[h],c,d+1);if(!c)return"["+f.join(",")+"]";a=g(c,d);c=g(c,d+1);return"[\n"+c+f.join(",\n"+c)+"\n"+a+"]"}if("function"===typeof a.toString)return a.toString();throw"unhandled case in switch";}return b(c,d,0)};H.cacheString=function(c){var d=m.encode(c);G.BUF2STR&&G.BUF2STR.set(d,c);r.STR2BUF&&r.STR2BUF.set(c,d)};H.opaType=A;H.Serializer=r;H.EventClient=F;H.PartialParser=G;
}());
